/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType;
import org.eclipse.mddi.modelbus.description.abstract_.Type;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.ETValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.EValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.MPValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.MSIValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.MSValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.MetaSValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.PValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.TValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.ToolValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.EException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ETException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MPException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSIException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MetaSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.PException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ToolException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TypeFormatException;

public class Validation {
    public static void globalValidation(ModelBusPackaging mp) throws MPException, MSIException, TException, EException, ETException, NameFormatException, MetaSException, MSException, PException, ToolException {
        EList mPContents = mp.getContent();
        int toolFound = 0;
        int i = 0;
        while (i < mPContents.size()) {
            Object mPContent = mPContents.get(i);
            if (mPContent instanceof Tool) {
                ++toolFound;
                ToolValidation.validateTool(mp);
            }
            ++i;
        }
        if (toolFound == 0) {
            throw new MPException("ModelBusPackage \"" + mp.getName() + "\" has no \"Tool\" definition. It should have exectly one \"Tool\" in the main ModelBusPackage");
        }
        if (toolFound > 1) {
            throw new MPException("ModelBusPackage \"" + mp.getName() + "\" has more than one Tool, this main ModelBusPackage" + " must have exactly one Tool");
        }
        Validation.globalValidationRec(mp);
        if (MPValidation.getToolsFound() != 1) {
            throw new MPException("ModelBusPackage \"" + mp.getName() + "\" has " + MPValidation.getToolsFound() + " Tool(s) in its children, only the main ModelBusPackage (root of file) " + "must have exactly one Tool");
        }
        if (!MPValidation.isMsiFound()) {
            throw new MPException("ModelBusPackage \"" + mp.getName() + "\" has no ModelingServiceInterface, it must have at least one as " + "child or one in its ModelbuPackaging children");
        }
    }

    public static void globalValidationRec(ModelBusPackaging mp) throws MPException, MSIException, TException, EException, ETException, NameFormatException, MetaSException, MSException, PException, ToolException {
        MPValidation.validateMP(mp);
        MSIValidation.validateMSI(mp);
        EValidation.validationE(mp);
        ETValidation.validationET(mp);
        MetaSValidation.validateMetaS(mp);
        MSValidation.validationMS(mp);
        PValidation.validationParameter(mp);
        TValidation.validationT(mp);
        MSValidation.validationMS(mp);
        PValidation.validationParameter(mp);
    }

    /*
     * Unable to fully structure code
     */
    public static void validateName(String name, String className) throws NameFormatException {
        javaReservedKeywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
        primitiveTypes = new HashSet<String>();
        primitiveTypes.add("boolean");
        primitiveTypes.add("double");
        if (name == null) {
            throw new NameFormatException("The " + className + " has its name attribute missing");
        }
        if (name.equals("")) {
            throw new NameFormatException("The" + className + " has its name attribute empty");
        }
        try {
            intName = Integer.parseInt(name.substring(0, 1));
            throw new NameFormatException(String.valueOf(className) + " name: \"" + name + "\" begins with number " + intName + ", names must not begin with numbers");
        }
        catch (NumberFormatException v0) {
            i = 0;
            ** while (i < javaReservedKeywords.length)
        }
lbl-1000:
        // 1 sources

        {
            if (className.equals("PrimitiveType") && primitiveTypes.contains(name)) {
                return;
            }
            if (javaReservedKeywords[i].equals(name)) {
                throw new NameFormatException("The " + className + " has its name=" + name + " which is a reserved keyword of Java");
            }
            ++i;
            continue;
        }
lbl23:
        // 1 sources

        i = 0;
        while (i < name.length()) {
            if (!(name.charAt(i) == '_' || name.charAt(i) == '$' || name.charAt(i) >= '0' && name.charAt(i) <= '9' || name.charAt(i) >= 'A' && name.charAt(i) <= 'Z' || name.charAt(i) >= 'a' && name.charAt(i) <= 'z')) {
                throw new NameFormatException("The " + className + " has a wrong name format: \"" + name + "\" contains forbidden letters. Authorized letters are : a-z A-Z, numbers 0-9, underscore or dollarsign");
            }
            ++i;
        }
    }

    public static void validateType(Type type, String className) throws TypeFormatException {
        if (type == null) {
            throw new TypeFormatException("A Type has its type attribute missing");
        }
        if (type.getName().equals("")) {
            throw new TypeFormatException("A Typehas its type attribute missing");
        }
        if (!(!(type instanceof PrimitiveType) || type.getName().equalsIgnoreCase("string") || type.getName().equalsIgnoreCase("double") || type.getName().equalsIgnoreCase("boolean") || type.getName().equalsIgnoreCase("integer") || type.getName().equalsIgnoreCase("binary"))) {
            throw new TypeFormatException("Type \"" + type.getName() + "\" has a wrong PrimitiveType, it must be \"string\"," + " \"double\", \"integer\", \"boolean\" or \"binary\"");
        }
    }
}

