/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.description.presentation;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import modelbus.description.presentation.ModelbusEditorPlugin;
import modelbus.description.provider.ModelbusEditPlugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mddi.modelbus.description.DescriptionPackage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DescriptionModelWizardInitialObjectCreationPage
extends WizardPage {
    protected String initialObjectName;
    protected DescriptionPackage descriptionPackage = DescriptionPackage.eINSTANCE;
    protected Combo initialObjectField;
    protected String encoding;
    protected Combo encodingField;

    public DescriptionModelWizardInitialObjectCreationPage(String pageId) {
        super(pageId);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label containerLabel = new Label(composite, 16384);
        containerLabel.setText(ModelbusEditorPlugin.INSTANCE.getString("_UI_ModelObject"));
        data = new GridData();
        data.horizontalAlignment = 4;
        containerLabel.setLayoutData((Object)data);
        this.initialObjectField = new Combo(composite, 2048);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.initialObjectField.setLayoutData((Object)data);
        ArrayList<String> objectNames = new ArrayList<String>();
        Iterator classifier = this.descriptionPackage.getEClassifiers().iterator();
        while (classifier.hasNext()) {
            EClass eClass;
            EClassifier eClassifier = (EClassifier)classifier.next();
            if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
            objectNames.add(this.getLabel(eClass));
        }
        Collections.sort(objectNames, Collator.getInstance());
        Iterator i = objectNames.iterator();
        while (i.hasNext()) {
            String objectName = (String)i.next();
            this.initialObjectField.add(objectName);
        }
        this.initialObjectField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DescriptionModelWizardInitialObjectCreationPage.this.setPageComplete(DescriptionModelWizardInitialObjectCreationPage.this.isPageComplete());
            }
        });
        Label encodingLabel = new Label(composite, 16384);
        encodingLabel.setText(ModelbusEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
        GridData data2 = new GridData();
        data2.horizontalAlignment = 4;
        encodingLabel.setLayoutData((Object)data2);
        this.encodingField = new Combo(composite, 2048);
        data2 = new GridData();
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        this.encodingField.setLayoutData((Object)data2);
        StringTokenizer stringTokenizer = new StringTokenizer(ModelbusEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
        while (stringTokenizer.hasMoreTokens()) {
            this.encodingField.add(stringTokenizer.nextToken());
        }
        this.encodingField.select(0);
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        if (super.isPageComplete()) {
            return this.initialObjectField.getSelectionIndex() != -1;
        }
        return false;
    }

    public boolean performFinish() {
        this.initialObjectName = this.getInitialObjectName();
        this.encoding = this.getEncoding();
        return true;
    }

    public String getInitialObjectName() {
        if (this.initialObjectName != null) {
            return this.initialObjectName;
        }
        String label = this.initialObjectField.getText();
        Iterator classifier = this.descriptionPackage.getEClassifiers().iterator();
        while (classifier.hasNext()) {
            EClass eClass;
            EClassifier eClassifier = (EClassifier)classifier.next();
            if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || !this.getLabel(eClass).equals(label)) continue;
            return eClass.getName();
        }
        return label;
    }

    public String getEncoding() {
        return this.encoding == null ? this.encodingField.getText() : this.encoding;
    }

    protected String getLabel(EClass eClass) {
        String name = eClass.getName();
        try {
            return ModelbusEditPlugin.INSTANCE.getString("_UI_" + name + "_type");
        }
        catch (MissingResourceException missingResourceException) {
            return name;
        }
    }
}

