/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.description.impl.DescriptionPackageImpl;


/**
 * 
 * Loads a model into a EMF object
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner, Saoussen Kraiem, Rmy-Christophe Schermesser, Marc Schwitzgubel 
 * 
 */
public class DescriptionModelLoader {

	/**
	 * ModelBusPackaging model the generated model
	 */
	protected ModelBusPackaging model = null;
	
	/**
	 * ArrayList modelingServicesInterfaces
	 */
	protected ArrayList modelingServicesInterfaces = null;
	
	/**
	 * Tool tool
	 */
	protected Tool tool = null;
	
	/**
	 * 
	 * Loads a model from a description file
	 * 
	 * @param fileName The file to load
	 * @throws IOException 
	 */
	public DescriptionModelLoader(String fileName) throws IOException {
		DescriptionPackageImpl.init();
	    Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
	    ResourceSet rSet = new ResourceSetImpl();
		Resource res = rSet.createResource(org.eclipse.emf.common.util.URI.createURI("modelbus"));
		FileInputStream in = new FileInputStream(fileName);
		res.load(in, new HashMap());
		in.close();
        
		model = (ModelBusPackaging) res.getContents().get(0);
		modelingServicesInterfaces = new ArrayList();
		createModelBusPackaging(model);
		searchTool(model);
	}

	/**
	 * 
	 * Return the ModelingServiceInterfaces of this model
	 * 
	 * @return ModelingServiceInterface[]
	 */
	public ModelingServiceInterface[] getModelingServiceInterfaces() {
		ModelingServiceInterface[] retour = new ModelingServiceInterface[modelingServicesInterfaces.size()];
		retour = (ModelingServiceInterface[])modelingServicesInterfaces.toArray(retour);
		return retour;
	}
	
	/**
	 * 
	 * Return the node Tool of this model
	 * 
	 * @return The Tool node
	 */
	public Tool getTool() {
		return tool;
	}
	
	/**
	 * 
	 * Create the list of the ModelingServicesInterfaces
	 * 
	 * @param mp The ModelBusPackaging to start the search
	 */
	private void createModelBusPackaging(ModelBusPackaging mp) {
		EList contents = mp.eContents();
		for(int i=0 ; i<contents.size() ; i++) {
			if(contents.get(i) instanceof ModelingServiceInterface) {
				modelingServicesInterfaces.add(contents.get(i));
			}
			if(contents.get(i) instanceof ModelBusPackaging) {
				createModelBusPackaging((ModelBusPackaging)contents.get(i));
			}
		}
	}
	
	/**
	 * 
	 * Search for the tool in the model
	 * 
	 * @param mp The ModelBusPackaging to start the search
	 */
	private void searchTool(ModelBusPackaging mp) {
		EList contents = mp.getContent();
		for(int i=0 ; i<contents.size() ; i++) {
			if(contents.get(i) instanceof Tool) {
				this.tool = (Tool)contents.get(i);
				return;
			}
			if(contents.get(i) instanceof ModelBusPackaging) {
				searchTool((ModelBusPackaging)contents.get(i));
			}
		}
	}

	/**
	 * 
	 * Return the node ModelBusPackaging of this model
	 * 
	 * @return ModelBusPackaging The ModelBusPackaging node
	 */
	public ModelBusPackaging getModelBusPackaging() {
		return model;
	}
}