/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;

import org.eclipse.mddi.modelbus.toolkit.adapter.generator.ProviderInterfaceGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.SkeletonGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.StubGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.EException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ETException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MPException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSIException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MetaSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.PException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ToolException;

/**
 * 
 * Console front end of the generator
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Rmy-Christophe Schermesser, Marc Schwitzgubel
 *  
 */
public class Toolkit {

    /**
     * String HELP_OPTION : String for the help option
     */
    protected static final String HELP_OPTION = "-help";

    /**
     * String OUTPUT_DIRECTORY_OPTION : String for the output directory option
     */
    protected static final String OUTPUT_DIRECTORY_OPTION = "-directory";

    /**
     * String OUTPUT_PACKAGE_OPTION : String for the output package option
     */
    protected static final String OUTPUT_PACKAGE_OPTION = "-package";

    /**
     * 
     * Main method for the console mode of the ToolKit
     * 
     * @param args
     *            The parameter of this program
     *  
     */
public static void main(String[] args) {
		try {
			Hashtable arguments = new Hashtable();

			for(int i = 1; i < args.length; i++) {
				if(args[i].compareTo(OUTPUT_DIRECTORY_OPTION) == 0 ||
				   args[i].compareTo(OUTPUT_PACKAGE_OPTION) == 0) {
					arguments.put(args[i], args[i + 1]);
					i++;
				} else {
					throw new Exception();
				}
			}

			String fileName = args[0];
			String outputDirectory = (String)arguments.get(OUTPUT_DIRECTORY_OPTION);
			String outputPackage = (String)arguments.get(OUTPUT_PACKAGE_OPTION);
			
			if(outputDirectory == null) {
				outputDirectory = ".";
			}
			if(outputPackage == null) {
				outputPackage = "";
			}
			
			try {
				DescriptionModelLoader modelLoader = new DescriptionModelLoader(fileName);
				Validation.globalValidation(modelLoader.getModelBusPackaging());
				System.out.println("Tool description validated");
				StubGenerator.generateAdapter(modelLoader, outputDirectory, outputPackage);
				System.out.println("Tool Stub Generated");
				
				//Provider Interface generator
				ProviderInterfaceGenerator intGen = new ProviderInterfaceGenerator(modelLoader.getTool(),outputDirectory);
				intGen.generateContent(outputPackage,modelLoader.getModelingServiceInterfaces()[0]);
				System.out.println("Tool Provider Interface Generated");

				//Skeleton generator
				SkeletonGenerator skelGen = new SkeletonGenerator(modelLoader.getTool(),outputDirectory);
				skelGen.generateContent(outputPackage,modelLoader.getModelingServiceInterfaces()[0]);
				System.out.println("Tool Skeleton Generated");

			} catch(Exception e) {
				if (e instanceof MetaSException 
						|| e instanceof MPException
						|| e instanceof MSIException
						|| e instanceof TException
						|| e instanceof EException
						|| e instanceof ETException
						|| e instanceof NameFormatException
						|| e instanceof MetaSException
						|| e instanceof MSException
						|| e instanceof PException
						|| e instanceof ToolException)
					System.out.println(e.getMessage());	
				else {
					System.out.println(e.getMessage());
					e.printStackTrace();
				}
			}
		} catch (Exception e) {		
			printHelp();
		}
	}
    /**
     * Print the help message
     */
    protected static void printHelp() {
        System.out
                .println("Usage: java -classpath \"path_to_org.eclipse.mddi.modelbus.toolkit.jar\" "
                        + "org.eclipse.mddi.modelbus.toolkit.Toolkit \"path_to_myTool.description\" [-options]\n"
                        + "\n"
                        + "where options include:\n"
                        + "\t"
                        + OUTPUT_DIRECTORY_OPTION
                        + "\tto specify an existing output directory for the generated files\n"
                        + "\t"
                        + OUTPUT_PACKAGE_OPTION
                        + "\tto specify the package name for the generated files\n"
                        + "\t"
                        + HELP_OPTION
                        + "\t\tto print this message\n"
                        + "\n"
                        + "For further help please see the user manual\n");
    }

}
