/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

/**
 * 
 * Generic holder
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner, Saoussen Kraiem, Rmy-Christophe Schermesser, Marc Schwitzgubel
 *
 */
public abstract class Holder {

	protected String name;
	protected String type;
	
	/**
	 * 
	 * Constructor using a parameter
	 * 
	 * @param parameter The parameter 
	 */
	public Holder(Parameter parameter) {
		name = parameter.getName();
		type = TypeConversion.generateType(parameter);
	}
	
	/**
	 * 
	 * Default Constructor
	 * 
	 */
	public Holder() {
		//Need for subclasses
	}
	
	/**
	 * 
	 * Get the name of this holder
	 * 
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	

	/**
	 * 
	 * Get type the type of this holder
	 * 
	 * @return Returns the type.
	 */
	public String getType() {
		return type;
	}
}
