/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import java.io.IOException;
import java.io.OutputStream;

import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;

/**
 * 
 * StubGenerator of the interfaces and stubs
 * 
 * @author Andrey Sadovykh (LIP6)
 *  
 */
public class ProviderInterfaceGenerator extends AbstractGenerator {

    /**
     * Constants for the name of the generated class, interface, method
     */

    protected static final String EXECUTE_METHOD_PREFIX = "execute_";

    /**
     * @param t
     * @param os
     */
    public ProviderInterfaceGenerator(Tool t, OutputStream os) {
        super(t, os);
        FILE_POSTFIX = "ProviderInterface";
    }

    /**
     * @param tool
     * @param outputDirectory
     */
    public ProviderInterfaceGenerator(Tool tool, String outputDirectory) {
        super(tool, outputDirectory);
        FILE_POSTFIX = "ProviderInterface";
        fileOs = getFileOs();        
    }

    protected void generateImport() throws IOException {
        fileOs.write(("import java.util.Collection;\n").getBytes());
        fileOs
                .write(("import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;\n")
                        .getBytes());
        fileOs
                .write(("import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;\n")
                        .getBytes());
        fileOs.write(("\n").getBytes());
    }

    public void generateClassName() throws IOException {
        fileOs.write(("public interface " + getFileName() + " {\n").getBytes());
    }

    protected void generateServiceMethods(ModelingService ms, String ToolName,
            String ModelingInterfaceName) throws IOException {
        
        String methodName = EXECUTE_METHOD_PREFIX+ms.getName();
        String outputType = generateOutputParameters(createOutputHolders(ms));
        
        InputHolder [] inputs = createInputHolders(ms);

        //comment
        String comment=getMethodComment(EXECUTE_METHOD_PREFIX,ms);
        
        comment+="\t * @throws ModelingServiceError\n";
        comment+="\t * @throws SessionNeeded\n";
        comment+="\t **/\n";
        //

        String methodSignature=comment;
        methodSignature += "\tpublic ";
        methodSignature += outputType+" ";
        methodSignature +=  methodName;
        methodSignature +=  "(";
        methodSignature += generateInputParameters(inputs);
        methodSignature += ")  throws ModelingServiceError, SessionNeeded;\n\n";

        fileOs.write(methodSignature.getBytes());
    }

    public static void main(String[] params) {
        DescriptionModelLoader loader;
        try {
            loader = new DescriptionModelLoader("OCLTool.description");
            ProviderInterfaceGenerator gen = new ProviderInterfaceGenerator(
                    loader.getTool(), System.out);

            gen.generateContent("some.pack", loader
                    .getModelingServiceInterfaces()[0]);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

    }

}