/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import java.io.IOException;
import java.io.OutputStream;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;

/**
 * 
 * SkeletonGenerator
 * 
 * @author Andrey Sadovykh (LIP6)
 *  
 */
public class SkeletonGenerator extends AbstractGenerator {

    /**
     * Constants for the name of the generated class, interface, method
     */

    protected static final String EXECUTE_METHOD_PREFIX = "execute_";

    private String interfaceName = (new ProviderInterfaceGenerator(
            toolDescription, fileOs)).getFileName();

    /**
     * @param t
     * @param os
     */
    public SkeletonGenerator(Tool t, OutputStream os) {
        super(t, os);
        FILE_POSTFIX = "Skeleton";
    }

    /**
     * @param tool
     * @param outputDirectory
     */
    public SkeletonGenerator(Tool tool, String outputDirectory) {
        super(tool, outputDirectory);
        FILE_POSTFIX = "Skeleton";
        fileOs = getFileOs();
    }

    protected void generateImport() throws IOException {
        fileOs.write(("import java.util.Collection;\n").getBytes());
        fileOs
                .write(("import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;\n")
                        .getBytes());
        fileOs
                .write(("import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;\n")
                        .getBytes());
        fileOs
                .write(("import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;\n")
                        .getBytes());
        fileOs.write(("\n").getBytes());
    }

    public void generateClassName() throws IOException {
        fileOs
                .write(("public class " + getFileName() + " implements GenericProvider {\n")
                        .getBytes());
    }

    public void generateConstructor() throws IOException {

        String constructor = "";

        //private SampleToolProviderInterface concreteTool;

        constructor += "\tprivate ";

        constructor += interfaceName;
        constructor += " concreteTool;\n\n";

        //public SampleToolSkeleton(SampleToolProviderInterface concreteTool) {
        //      this.concreteTool = concreteTool;
        //  }

        constructor += "\tpublic ";
        constructor += getFileName();
        constructor += "(";
        constructor += interfaceName;
        constructor += " concreteTool";
        constructor += ") {\n";
        constructor += "\t\tthis.concreteTool = concreteTool;\n";

        constructor += "\t}\n";

        fileOs.write(constructor.getBytes());

    }

    protected void generateAdditionalMethods(ModelingServiceInterface msi)
            throws IOException {
        String code = "";
        //Lets generate declaration of execute method

        //public Object[] execute(String serviceName, Object[] parameterValues)
        // throws SessionNeeded, ModelingServiceError {

        code += "\tpublic Object[] execute(String serviceName, Object[] parameterValues) throws SessionNeeded, ModelingServiceError {\n";

        //for each serviceName generate "if" statement
        code += "\t\t";
        EList services = msi.eContents();

        for (int i = 0; i < services.size(); i++) {
            ModelingService ms = (ModelingService) services.get(i);
            //for each serviceName generate "if" statement
            code += generateIf(ms);
        }

        //else{
        //        throw new ModelingServiceError ("No such service: "+serviceName,
        // null);
        //    }
        code += "{\n";
        code += "\t\t\tthrow new ModelingServiceError (\"No such service: \"+serviceName, null);\n";
        code += "\t\t}\n";
        code += "\t}\n\n";
        fileOs.write(code.getBytes());
    }

    String generateIf(ModelingService ms) {

        InputHolder[] inputs = createInputHolders(ms);
        OutputHolder[] outputs = createOutputHolders(ms);
        String outputType = generateOutputParameters(outputs);

        String code = "";
        code += "if (serviceName.equals(\"";
        code += ms.getName();
        code += "\")){\n";
        // "if" body

        //execute implementation
        code += "\t\t\t";
        if (outputType.equals("void")) {

            code += "concreteTool.execute_";
        } else {
            code += outputType;
            code += " result=concreteTool.execute_";
        }

        code += ms.getName();
        code += "(";
        code += generateExecuteParameters(inputs);
        code += ");\n";

        //declare returnValues

        if (outputType.equals("void")) {

            code += "\t\t\tObject[] returnValues = new Object[0];\n";
        } else code += "\t\t\tObject[] returnValues = new Object[" + outputs.length
                + "];\n";

        //fill returnValues
        if (outputType.equals("void")) {

            //DO NOTHING
        } else if (outputs.length == 1) {
            code += "\t\t\treturnValues[0]=result;\n";
        } else
            for (int i = 0; i < outputs.length; i++) {
                code += "\t\t\treturnValues[" + i + "]=result."
                        + outputs[i].getName() + ";\n";
            }

        //return value

        code += "\t\t\treturn returnValues;\n";
        code += "\t\t}else ";
        return code;
    }

    String generateExecuteParameters(InputHolder[] inputs) {

        String code = "";

        for (int i = 0; i < inputs.length; i++) {
            code += "(";
            code += inputs[i].getType();
            code += ") parameterValues[" + i + "]";
            if (i != inputs.length - 1)
                code += ",";
        }
        return code;
    }

    public static void main(String[] params) {
        DescriptionModelLoader loader;
        try {
            loader = new DescriptionModelLoader("OCLTool.description");
            SkeletonGenerator gen = new SkeletonGenerator(loader.getTool(),
                    System.out);

            gen.generateContent("some.pack", loader
                    .getModelingServiceInterfaces()[0]);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

    }

}