/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.test;

import java.io.IOException;

import junit.framework.TestCase;

import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.MSIValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSIException;

/**
 * 
 * Check that ModelingServiceInterfaceException are correctly thrown
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 *  
 */
public class MSIValidationTest extends TestCase {

	/**
	 * 
	 * Test that MSIException are thrown when needed
	 *  
	 */
	public static void testValidationMSI() {
		String xmlFileName;
		DescriptionModelLoader modelLoader;
		
		
		xmlFileName = "MSI_missingName.description";
		try {
			modelLoader = new DescriptionModelLoader(
					ValidationTest.getDescriptionFilesPath() + xmlFileName);
			MSIValidation.validateMSI(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (MSIException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}

		xmlFileName = "MSI_emptyName.description";
		try {
			modelLoader = new DescriptionModelLoader(
					ValidationTest.getDescriptionFilesPath() + xmlFileName);
			MSIValidation.validateMSI(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (MSIException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}

		xmlFileName = "MSI_sameName.description";
		try {
			modelLoader = new DescriptionModelLoader(
					ValidationTest.getDescriptionFilesPath() + xmlFileName);
			MSIValidation.validateMSI(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (MSIException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}

		xmlFileName = "MSI_emptyMSI.description";
		try {
			modelLoader = new DescriptionModelLoader(
					ValidationTest.getDescriptionFilesPath() + xmlFileName);
			MSIValidation.validateMSI(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (MSIException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}

		xmlFileName = "MSI_wrongNameFormat.description";
		try {
			modelLoader = new DescriptionModelLoader(
					ValidationTest.getDescriptionFilesPath() + xmlFileName);
			MSIValidation.validateMSI(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (MSIException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}

	}

}
