/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus. All rights
 * reserved.
 * 
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.test;

import java.io.IOException;

import junit.framework.TestCase;

import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.MSValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSException;

/**
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 *  
 */
public class MSValidationTest extends TestCase {

	/**
	 * 
	 * Test that ServiceException are thrown when needed
	 *  
	 */
	public static void testValidationMS() {

		String xmlFileName;
		DescriptionModelLoader modelLoader;

		xmlFileName = "MS_missingName.description";
		try {
			modelLoader = new DescriptionModelLoader(ValidationTest.
					getDescriptionFilesPath()+ xmlFileName);
			MSValidation.validationMS(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (IOException e1) {
			assertEquals(false, true);
		} catch (MSException e1) {
			assertEquals(false, false);
		}

		xmlFileName = "MS_emptyName.description";
		try {
			modelLoader = new DescriptionModelLoader(ValidationTest.
					getDescriptionFilesPath()+ xmlFileName);
			MSValidation.validationMS(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (IOException e1) {
			assertEquals(false, true);
		} catch (MSException e1) {
			assertEquals(false, false);
		}
	}

}
