/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.test;

import java.io.IOException;

import junit.framework.TestCase;

import org.eclipse.mddi.modelbus.toolkit.adapter.validator.MetaSValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MetaSException;

/**
 * 
 * Check that ModelingServiceInterfaceException are correctly thrown
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 *  
 */
public class MetaSValidationTest extends TestCase {

	/**
	 * 
	 * Test that MetaSExcecption are thrown when needed
	 *  
	 */
	public static void testValidationMetaS() {
		String xmlFileName;
		org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader modelLoader;
		xmlFileName = "MetaS_wrongUpper.description";
		try {
			modelLoader = new org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader(
					ValidationTest.getDescriptionFilesPath() + xmlFileName);
			MetaSValidation.validateMetaS(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (MetaSException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}

		xmlFileName = "MetaS_lowerGreaterThanUpper.description";
		try {
			modelLoader = new org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader(
					ValidationTest.getDescriptionFilesPath() + xmlFileName);
			MetaSValidation.validateMetaS(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (MetaSException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}

		xmlFileName = "MetaS_missingName.description";
		try {
			modelLoader = new org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader(
					ValidationTest.getDescriptionFilesPath() + xmlFileName);
			MetaSValidation.validateMetaS(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (MetaSException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}

		xmlFileName = "MetaS_wrongNameFormat.description";
		try {
			modelLoader = new org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader(
					ValidationTest.getDescriptionFilesPath() + xmlFileName);
			MetaSValidation.validateMetaS(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (MetaSException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}

		xmlFileName = "MetaS_emptyName.description";
		try {
			modelLoader = new org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader(
					ValidationTest.getDescriptionFilesPath() + xmlFileName);
			MetaSValidation.validateMetaS(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (MetaSException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}

		xmlFileName = "MetaS_noUpperLower.description";
		try {
			modelLoader = new org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader(
					ValidationTest.getDescriptionFilesPath() + xmlFileName);
			MetaSValidation.validateMetaS(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (MetaSException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}

		xmlFileName = "MetaS_wrongLower.description";
		try {
			modelLoader = new org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader(
					ValidationTest.getDescriptionFilesPath() + xmlFileName);
			MetaSValidation.validateMetaS(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (MetaSException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}
	}

}
