/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.test;

import junit.framework.TestCase;

/**
 * 
 * Check that validation errors are correctly thrown
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 *  
 */
public class ValidationTest extends TestCase {

	final static String descriptionFilesPath = "./resources/";

	/**
	 * Test that description errors are thrown when needed
	 *
	 */
	public void testGlobalValidation() {
		try {
			MSIValidationTest.testValidationMSI();
			EValidationTest.testValidationE();
			ETValidationTest.testValidationET();
			MetaSValidationTest.testValidationMetaS();
			MSValidationTest.testValidationMS();
			PValidationTest.testValidationParameter();
			TValidationTest.testValidationT();
			MSValidationTest.testValidationMS();
			assertEquals(false, false);//everything is OK
		} catch (Exception e) {
			e.printStackTrace();
			assertEquals(false, true);//something wrong
			System.out.println(e.getMessage());
		}
	}

	/**
	 * @return Returns the descriptionFilesPath.
	 */
	public static String getDescriptionFilesPath() {
		return descriptionFilesPath;
	}

}
