/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.Event;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ETException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;

/**
 * 
 * Check that EventType are correctly formed
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 *  
 */
public class ETValidation {

	/**
	 * This method validates the part of the description which specifies an
	 * EventType.
	 * 
	 * @param mp
	 * @throws ETException
	 */
	public static void validationET(ModelBusPackaging mp) throws ETException {
		EList eventsList, mpListContents;
		mpListContents = mp.getContent();

		ModelingServiceInterface msi = null;
		for (int j = 0; j < mpListContents.size(); j++) {
			Object content = mpListContents.get(j);
			if (content instanceof ModelingServiceInterface) {
				msi = (ModelingServiceInterface) content;
			}

			//We put the event in a EList
			if (msi != null) {
				eventsList = msi.getPublishedEvent();
				for (int i = 0; i < eventsList.size(); i++) {
					Event event = (Event) eventsList.get(i);
					//validate the name of the event
					try {
						Validation.validateName(event.getName(), "Event");
					} catch (NameFormatException e) {
						throw new ETException(e.getMessage());
					}
					//validate the type(s) of the event
					EList types = event.getEventInfo();
					if(types.isEmpty()){
						throw new ETException("Event \"" + event.getName() 
								+ "\" has an empty type(eventType) attribute, it must have at least one type referenced");
					}
					//eventInfo is yet check in the class TValidation
				}
			}
		}
	}
}
