/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSIException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;

/**
 * 
 * Check that ModelingServiceInterface are correctly thrown
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 *  
 */
public class MSIValidation {

	/**
	 * This method validates the part of the description which specifies a
	 * ModelingServiceInterface.
	 * 
	 * @param mP
	 * @throws MSIException
	 */
	public static void validateMSI(ModelBusPackaging mP) throws MSIException {
		EList mPContents = mP.getContent();
		ArrayList msiNameList = new ArrayList();
		int nextContent = 0;
		while (nextContent < mPContents.size()) {
			Object mPContent = mPContents.get(nextContent);
			if (mPContent instanceof ModelingServiceInterface) {
				ModelingServiceInterface msi = (ModelingServiceInterface) mPContent;
				//if the msi name is correct
				try {
					Validation.validateName(msi.getName(),
							"ModelingServiceInterface");
				} catch (NameFormatException e) {
					throw new MSIException(e.getMessage());
				}
				if (!msiNameList.contains(msi.getName())) {
					//if the msi is empty (no services and events)
					if (msi.getPublishedEvent().isEmpty()
							&& msi.getService().isEmpty()) {
						throw new MSIException("ModelingServiceInterface \""
								+ msi.getName() + "\" is empty, it must have at least one ModelingService or EventType");
					}
					msiNameList.add(msi.getName());
				} else {
					throw new MSIException(
							"At least two ModelingServiceInterface"
									+ " have the same name : \"" + msi.getName()+"\", it must have different names");
				}
			}
			nextContent++;
		}
	}

}
