/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import java.util.Vector;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.DirectionKind;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.PException;

/**
 * 
 * Check that Parameter are correctly formed
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 */
public class PValidation {

	/**
	 * PValidation DEFAULT_LOWER
	 */
	public final static int DEFAULT_LOWER = 0;

	/**
	 * PValidation DEFAULT_UPPER
	 */
	public final static int DEFAULT_UPPER = 1;

	/**
	 * 
	 * This method validates the part of the description which specifies
	 * Parameter.
	 * 
	 * @param mP
	 * @throws PException
	 */
	public static void validationParameter(ModelBusPackaging mP)
			throws PException {
		EList mPContents = mP.getContent();
		int nextContent = 0;
		while (nextContent < mPContents.size()) {
			Object mPContent = mPContents.get(nextContent);
			nextContent++;
			if (mPContent instanceof ModelingServiceInterface) {
				ModelingServiceInterface msi = (ModelingServiceInterface) mPContent;
				EList parametersList;
				ModelingService service;
				EList servicesList;
				Parameter parameter;
				// We recover all the services of the ModelingServiceInterface
				servicesList = msi.getService();

				for (int i = 0; i < servicesList.size(); i++) {
					service = (ModelingService) servicesList.get(i);
					// For each service, we check if all parameters are build
					// correctly
					parametersList = service.getParameter();

					Vector paramList = new Vector();
					for (int j = 0; j < parametersList.size(); j++) {
						parameter = (Parameter) parametersList.get(j);
						try {
							Validation.validateName(parameter.getName(),
									"Parameter");
						} catch (NameFormatException e) {
							throw new PException(e.getMessage());
						}

						if (parameter.getDirection() == null) {
							parameter.setDirection(DirectionKind.IN_LITERAL);
						}
						if ((parameter.getLower() == 0)
								&& (parameter.getUpper() == 0)) {
							throw new PException(
									"Parameter \""
											+ parameter.getName()
											+ "\" has its lower and upper attributes equal to 0");
						}
						if (parameter.getUpper() < parameter.getLower()
								&& parameter.getUpper() > 0) {
							throw new PException(
									"Parameter \""
											+ parameter.getName()
											+ "\" has its lower attribute superior as its upper attribute");
						}
						if ((parameter.getDirection().getValue() != DirectionKind.IN)
								&& (parameter.getDirection().getValue() != DirectionKind.OUT)
								&& (parameter.getDirection().getValue() != DirectionKind.INOUT)) {
							throw new PException(
									"Direction value \""
											+ parameter.getDirection()
											+ "\" must be : \"in\" or \"out\" or \"inout\"");
						}

						for (int k = 0; k < paramList.size(); k++) {
							if (((Parameter) paramList.get(k)).getName()
									.equals(parameter.getName())) {
								if (!((((Parameter) paramList.get(k)).getType())
										.equals(parameter.getType()))) {
									paramList.add(parameter);
								} else {
									throw new PException(
											"Parameter \""+parameter.getName()+"\" already exists");
								}
							}
						}

					}
				}
			}
		}
	}
}
