/*
 * $RCSfile: ToolkitGenerateAction.java,v $ $Date: 2006/07/10 17:51:27 $
 * $Revision: 1.6 $ $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus. All rights
 * reserved.
 * 
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ToolkitGenerateAction Add description
 * 
 * @author Andrey Sadovykh (LIP6)
 * 
 * @version $Revision: 1.6 $ $Date: 2006/07/10 17:51:27 $
 */
package org.eclipse.mddi.modelbus.toolkit.gui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.ProviderInterfaceGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.SkeletonGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.StubGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.EException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ETException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MPException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSIException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MetaSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.PException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ToolException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

/*
 * ToolkitAction
 *  
 */

public class ToolkitGenerateAction extends Action {

    protected EditingDomain domain;

    String selectedOutputDirectory;

    String selectedPackageName = "";

    /**
     *  
     */
    public ToolkitGenerateAction() {
        super("Generate Stubs/Skeletons");
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.action.Action#run()
     */
    public void run() {

        final Shell shell = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getShell();

        GenerationDialog dialog = new GenerationDialog(shell);
        dialog.setOutputDirectory(selectedOutputDirectory);
        dialog.setOutputPackage(selectedPackageName);

        dialog.open();

        selectedOutputDirectory = dialog.getOutputDirectory();

        selectedPackageName = dialog.getOutputPackage();

        System.out.println("Selected Folder:" + selectedOutputDirectory);
        System.out.println("Selected Package:" + selectedPackageName);

        try {
            DescriptionModelLoader modelLoader = new DescriptionModelLoader(
                    getFile().getLocation().toOSString());
            //MessageDialog.openInformation(null,"ModelBus Description
            // Validation", "Tool Description for SomeName is successfully
            // validated");
            Validation.globalValidation(modelLoader.getModelBusPackaging());

            System.out.println("Tool description validated");
            StubGenerator.generateAdapter(modelLoader, selectedOutputDirectory,
                    selectedPackageName);
            System.out.println("Tool Stub Generated");

            //Provider Interface generator
            ProviderInterfaceGenerator intGen = new ProviderInterfaceGenerator(
                    modelLoader.getTool(), selectedOutputDirectory);
            intGen.generateContent(selectedPackageName, modelLoader
                    .getModelingServiceInterfaces()[0]);
            System.out.println("Tool Provider Interface Generated");

            //Skeleton generator
            SkeletonGenerator skelGen = new SkeletonGenerator(modelLoader
                    .getTool(), selectedOutputDirectory);
            skelGen.generateContent(selectedPackageName, modelLoader
                    .getModelingServiceInterfaces()[0]);
            System.out.println("Tool Skeleton Generated");

        } catch (Exception e) {
            if (e instanceof MetaSException || e instanceof MPException
                    || e instanceof MSIException || e instanceof TException
                    || e instanceof EException || e instanceof ETException
                    || e instanceof NameFormatException
                    || e instanceof MetaSException || e instanceof MSException
                    || e instanceof PException || e instanceof ToolException)
                MessageDialog.openError(shell,
                        "ModelBus Description Validation", e.getMessage());
            else {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }

    }

    protected IFile getFile() {
        Resource resource = (Resource) domain.getResourceSet().getResources()
                .get(0);
        if (resource != null) {
            URI uri = resource.getURI();
            uri = resource.getResourceSet().getURIConverter().normalize(uri);
            String scheme = uri.scheme();
            if ("platform".equals(scheme) && uri.segmentCount() > 1
                    && "resource".equals(uri.segment(0))) {
                StringBuffer platformResourcePath = new StringBuffer();
                for (int j = 1, size = uri.segmentCount(); j < size; ++j) {
                    platformResourcePath.append('/');
                    platformResourcePath.append(uri.segment(j));
                }
                return ResourcesPlugin.getWorkspace().getRoot().getFile(
                        new Path(platformResourcePath.toString()));
            }
        }
        return null;
    }

    protected IFile getProjectFolder() {
        ResourcesPlugin.getWorkspace().getRoot().getFullPath();
        //PlatformUI.getWorkbench()..getActiveWorkbenchWindow().getShell().get

        Resource resource = (Resource) domain.getResourceSet().getResources()
                .get(0);
        if (resource != null) {
            URI uri = resource.getURI();
            uri = resource.getResourceSet().getURIConverter().normalize(uri);
            String scheme = uri.scheme();
            if ("platform".equals(scheme) && uri.segmentCount() > 1
                    && "resource".equals(uri.segment(0))) {
                StringBuffer platformResourcePath = new StringBuffer();
                for (int j = 1, size = uri.segmentCount(); j < size; ++j) {
                    platformResourcePath.append('/');
                    platformResourcePath.append(uri.segment(j));
                }
                return ResourcesPlugin.getWorkspace().getRoot().getFile(
                        new Path(platformResourcePath.toString()));
            }
        }
        return null;
    }

    public void setActiveEditor(IEditorPart editorPart) {
        if (editorPart instanceof IEditingDomainProvider) {
            domain = ((IEditingDomainProvider) editorPart).getEditingDomain();
            selectedOutputDirectory = getFile().getParent().getLocation()
                    .toOSString();
        }
    }

    public EList getModel() {
        Resource resource = (Resource) domain.getResourceSet().getResources()
                .get(0);
        if (resource != null) {
            return resource.getContents();
        }

        return null;
    }

    public static class GenerationDialog extends Dialog {
        public static int CONTROL_OFFSET = 10;

        protected EditingDomain domain;

        protected Text outputPackageField;

        protected Label outputDirLabel;

        protected String outputDirectory;

        protected String outputPackage;

        public GenerationDialog(Shell parent) {
            this(parent, null);
        }

        public GenerationDialog(Shell parent, EditingDomain domain) {
            super(parent);
            setShellStyle(getShellStyle() | SWT.MAX | SWT.RESIZE);
            this.domain = domain;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            //                        shell.setText("Generate Stubs/Skeletons for <"
            //                                + ToolkitUtils.getTool(domain.getResourceSet()).getName()
            //                                + "> tool.");

            shell.setText("ModelBus: Generate Stubs/Skeletons");
        }

        protected Control createDialogArea(Composite parent) {
            boolean resourcesBundleIsAvailable = (Platform
                    .getBundle("org.eclipse.core.resources") != null);

            Composite composite = (Composite) super.createDialogArea(parent);
            {
                FormLayout layout = new FormLayout();
                composite.setLayout(layout);

                GridData data = new GridData();
                data.verticalAlignment = GridData.FILL;
                data.grabExcessVerticalSpace = true;
                data.horizontalAlignment = GridData.FILL;
                data.grabExcessHorizontalSpace = true;
                if (!resourcesBundleIsAvailable) {
                    data.widthHint = 330;
                }
                composite.setLayoutData(data);
            }

            outputDirLabel = new Label(composite, SWT.LEFT);
            {
                outputDirLabel.setText("Output Directory:" + outputDirectory);
                FormData data = new FormData();
                data.top = new FormAttachment(0, CONTROL_OFFSET);
                data.left = new FormAttachment(0, CONTROL_OFFSET);
                data.right = new FormAttachment(100, -CONTROL_OFFSET);
                outputDirLabel.setLayoutData(data);
            }

            Button resourceURIBrowseFileSystemButton = new Button(composite,
                    SWT.PUSH);
            resourceURIBrowseFileSystemButton.setText("Change...");
            resourceURIBrowseFileSystemButton
                    .addSelectionListener(new SelectionAdapter() {
                        public void widgetSelected(SelectionEvent event) {
                            DirectoryDialog dirDialog = new DirectoryDialog(
                                    getShell());
                            String msg = "Please, select folder for generated subs/skeletons";
                            dirDialog.setMessage(msg);

                            dirDialog.setFilterPath(outputDirectory);
                            dirDialog.open();
                            outputDirectory = dirDialog.getFilterPath();

                            outputDirLabel.setText("Output Directory:"
                                    + outputDirectory);

                        }
                    });

            {
                FormData data = new FormData();
                data.right = new FormAttachment(100, -CONTROL_OFFSET);
                data.top = new FormAttachment(outputDirLabel, CONTROL_OFFSET);

                resourceURIBrowseFileSystemButton.setLayoutData(data);
            }

            Label outputPackageLabel = new Label(composite, SWT.LEFT);
            {
                outputPackageLabel.setText("Output Package:");
                FormData data = new FormData();
                data.top = new FormAttachment(
                        resourceURIBrowseFileSystemButton, CONTROL_OFFSET);
                data.left = new FormAttachment(0, CONTROL_OFFSET);
                data.right = new FormAttachment(100, -CONTROL_OFFSET);
                data.left = new FormAttachment(0, CONTROL_OFFSET);
                outputPackageLabel.setLayoutData(data);
            }

            outputPackageField = new Text(composite, SWT.BORDER);
            {
                FormData data = new FormData();
                data.top = new FormAttachment(outputPackageLabel,
                        CONTROL_OFFSET);
                data.left = new FormAttachment(0, CONTROL_OFFSET);
                data.right = new FormAttachment(100, -CONTROL_OFFSET);
                outputPackageField.setLayoutData(data);
                outputPackageField.setText(outputPackage);
            }

            Label separatorLabel = new Label(composite, SWT.SEPARATOR
                    | SWT.HORIZONTAL);
            {
                FormData data = new FormData();
                data.top = new FormAttachment(outputPackageField,
                        (int) (1.5 * CONTROL_OFFSET));
                data.left = new FormAttachment(0, -CONTROL_OFFSET);
                data.right = new FormAttachment(100, CONTROL_OFFSET);
                separatorLabel.setLayoutData(data);
            }

            composite.setTabList(new Control[] { outputPackageField,
                    resourceURIBrowseFileSystemButton });
            return composite;
        }

        protected void okPressed() {
            outputPackage = outputPackageField.getText();

            super.okPressed();
        }

        /**
         * @return Returns the outputDirectory.
         */
        protected synchronized String getOutputDirectory() {
            return outputDirectory;
        }

        /**
         * @param outputDirectory
         *            The outputDirectory to set.
         */
        protected synchronized void setOutputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
        }

        /**
         * @return Returns the outputPackage.
         */
        protected synchronized String getOutputPackage() {
            return outputPackage;
        }

        /**
         * @param outputPackage
         *            The outputPackage to set.
         */
        protected synchronized void setOutputPackage(String outputPackage) {
            this.outputPackage = outputPackage;
        }
    }

}
