/*
 * $RCSfile: ToolkitValidateAction.java,v $ $Date: 2006/07/07 16:07:42 $ $Revision: 1.2 $ $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus. All rights
 * reserved.
 * 
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ToolkitValidateAction Add description
 * 
 * @author Andrey Sadovykh (LIP6)
 * 
 * @version $Revision: 1.2 $ $Date: 2006/07/07 16:07:42 $
 */
package org.eclipse.mddi.modelbus.toolkit.gui;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.EException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ETException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MPException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSIException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MetaSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.PException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ToolException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

/*
 * ToolkitAction
 *  
 */

public class ToolkitValidateAction extends Action {

    protected EditingDomain domain;

    /**
     *  
     */
    public ToolkitValidateAction() {
        super("Validate Description");


    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.action.Action#run()
     */
    public void run() {
        System.out.println("Validate");
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();

        ModelBusPackaging mp = ToolkitUtils.getModelBusPackaging(domain.getResourceSet());

        try {
            //MessageDialog.openInformation(null,"ModelBus Description Validation", "Tool Description for SomeName is successfully validated");
            Validation.globalValidation(mp);
            
            MessageDialog.openInformation(shell,"ModelBus Description Validation", "Tool Description for "+ToolkitUtils.getTool(domain.getResourceSet()).getName()+" is successfully validated");
        } catch (Exception e) {

            MessageDialog.openError(shell,"ModelBus Description Validation", e.getMessage() );
            
            System.out.println(e);
            e.printStackTrace();
            
            
        }

    }

    
    
    public void setActiveEditor(IEditorPart editorPart)
    {
      if (editorPart instanceof IEditingDomainProvider)
      {
        domain = ((IEditingDomainProvider)editorPart).getEditingDomain();
      }
    }
    
    public EList getModel(){
        Resource resource = (Resource)domain.getResourceSet().getResources().get(0);
        if (resource != null)
        {
            return resource.getContents();
        }

        return null;
    }


}
