/*
 * $RCSfile: DescriptionModelWizardNewFileCreationPage.java,v $
 * $Date: 2006/02/06 16:19:28 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * DescriptionModelWizardNewFileCreationPage.java Add description 
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.1 $ $Date: 2006/02/06 16:19:28 $
 */
package org.eclipse.mddi.modelbus.description.presentation;

import modelbus.description.presentation.ModelbusEditorPlugin;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

/*
 * DescriptionModelWizardNewFileCreationPage
 * 
 */

public class DescriptionModelWizardNewFileCreationPage extends WizardNewFileCreationPage {
    /**
     * Remember the model file.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IFile modelFile;

    /**
     * Pass in the selection.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public DescriptionModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
        super(pageId, selection);
    }

    /**
     * The framework calls this to see if the file is correct.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected boolean validatePage() {
        if (super.validatePage()) {
            // Make sure the file ends in ".description".
            //
            String requiredExt = ModelbusEditorPlugin.INSTANCE.getString("_UI_DescriptionEditorFilenameExtension");
            String enteredExt = new Path(getFileName()).getFileExtension();
            if (enteredExt == null || !enteredExt.equals(requiredExt)) {
                setErrorMessage(ModelbusEditorPlugin.INSTANCE.getString("_WARN_FilenameExtension", new Object [] { requiredExt }));
                return false;
            }
            else {
                return true;
            }
        }
        else {
            return false;
        }
    }

    /**
     * Store the dialog field settings upon completion.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean performFinish() {
        modelFile = getModelFile();
        return true;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public IFile getModelFile() {
        return
            modelFile == null ?
                ResourcesPlugin.getWorkspace().getRoot().getFile(getContainerFullPath().append(getFileName())) :
                modelFile;
    }
}
