/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.description.impl.DescriptionPackageImpl;

public class DescriptionModelLoader {
    protected ModelBusPackaging model = null;
    protected ArrayList modelingServicesInterfaces = null;
    protected Tool tool = null;

    public DescriptionModelLoader(String fileName) throws IOException {
        DescriptionPackageImpl.init();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        ResourceSetImpl rSet = new ResourceSetImpl();
        Resource res = rSet.createResource(URI.createURI((String)"modelbus"));
        FileInputStream in = new FileInputStream(fileName);
        res.load((InputStream)in, new HashMap());
        in.close();
        this.model = (ModelBusPackaging)res.getContents().get(0);
        this.modelingServicesInterfaces = new ArrayList();
        this.createModelBusPackaging(this.model);
        this.searchTool(this.model);
    }

    public ModelingServiceInterface[] getModelingServiceInterfaces() {
        ModelingServiceInterface[] retour = new ModelingServiceInterface[this.modelingServicesInterfaces.size()];
        retour = this.modelingServicesInterfaces.toArray(retour);
        return retour;
    }

    public Tool getTool() {
        return this.tool;
    }

    private void createModelBusPackaging(ModelBusPackaging mp) {
        EList contents = mp.eContents();
        int i = 0;
        while (i < contents.size()) {
            if (contents.get(i) instanceof ModelingServiceInterface) {
                this.modelingServicesInterfaces.add(contents.get(i));
            }
            if (contents.get(i) instanceof ModelBusPackaging) {
                this.createModelBusPackaging((ModelBusPackaging)contents.get(i));
            }
            ++i;
        }
    }

    private void searchTool(ModelBusPackaging mp) {
        EList contents = mp.getContent();
        int i = 0;
        while (i < contents.size()) {
            if (contents.get(i) instanceof Tool) {
                this.tool = (Tool)contents.get(i);
                return;
            }
            if (contents.get(i) instanceof ModelBusPackaging) {
                this.searchTool((ModelBusPackaging)contents.get(i));
            }
            ++i;
        }
    }

    public ModelBusPackaging getModelBusPackaging() {
        return this.model;
    }
}

