/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit;

import java.util.Hashtable;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.ProviderInterfaceGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.SkeletonGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.StubGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.EException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ETException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MPException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSIException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MetaSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.PException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ToolException;

public class Toolkit {
    protected static final String HELP_OPTION = "-help";
    protected static final String OUTPUT_DIRECTORY_OPTION = "-directory";
    protected static final String OUTPUT_PACKAGE_OPTION = "-package";

    public static void main(String[] args) {
        block10: {
            try {
                Hashtable<String, String> arguments = new Hashtable<String, String>();
                int i = 1;
                while (i < args.length) {
                    if (args[i].compareTo(OUTPUT_DIRECTORY_OPTION) == 0 || args[i].compareTo(OUTPUT_PACKAGE_OPTION) == 0) {
                        arguments.put(args[i], args[i + 1]);
                        ++i;
                    } else {
                        throw new Exception();
                    }
                    ++i;
                }
                String fileName = args[0];
                String outputDirectory = (String)arguments.get(OUTPUT_DIRECTORY_OPTION);
                String outputPackage = (String)arguments.get(OUTPUT_PACKAGE_OPTION);
                if (outputDirectory == null) {
                    outputDirectory = ".";
                }
                if (outputPackage == null) {
                    outputPackage = "";
                }
                try {
                    DescriptionModelLoader modelLoader = new DescriptionModelLoader(fileName);
                    Validation.globalValidation(modelLoader.getModelBusPackaging());
                    System.out.println("Tool description validated");
                    StubGenerator.generateAdapter(modelLoader, outputDirectory, outputPackage);
                    System.out.println("Tool Stub Generated");
                    ProviderInterfaceGenerator intGen = new ProviderInterfaceGenerator(modelLoader.getTool(), outputDirectory);
                    intGen.generateContent(outputPackage, modelLoader.getModelingServiceInterfaces()[0]);
                    System.out.println("Tool Provider Interface Generated");
                    SkeletonGenerator skelGen = new SkeletonGenerator(modelLoader.getTool(), outputDirectory);
                    skelGen.generateContent(outputPackage, modelLoader.getModelingServiceInterfaces()[0]);
                    System.out.println("Tool Skeleton Generated");
                }
                catch (Exception e) {
                    if (e instanceof MetaSException || e instanceof MPException || e instanceof MSIException || e instanceof TException || e instanceof EException || e instanceof ETException || e instanceof NameFormatException || e instanceof MetaSException || e instanceof MSException || e instanceof PException || e instanceof ToolException) {
                        System.out.println(e.getMessage());
                        break block10;
                    }
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
            }
            catch (Exception exception) {
                Toolkit.printHelp();
            }
        }
    }

    protected static void printHelp() {
        System.out.println("Usage: java -classpath \"path_to_org.eclipse.mddi.modelbus.toolkit.jar\" org.eclipse.mddi.modelbus.toolkit.Toolkit \"path_to_myTool.description\" [-options]\n\nwhere options include:\n\t-directory\tto specify an existing output directory for the generated files\n\t-package\tto specify the package name for the generated files\n\t-help\t\tto print this message\n\nFor further help please see the user manual\n");
    }
}

