/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.gui;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.gui.ToolkitUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ToolkitValidateAction
extends Action {
    protected EditingDomain domain;

    public ToolkitValidateAction() {
        super("Validate Description");
    }

    public void run() {
        System.out.println("Validate");
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ModelBusPackaging mp = ToolkitUtils.getModelBusPackaging(this.domain.getResourceSet());
        try {
            Validation.globalValidation(mp);
            MessageDialog.openInformation((Shell)shell, (String)"ModelBus Description Validation", (String)("Tool Description for " + ToolkitUtils.getTool(this.domain.getResourceSet()).getName() + " is successfully validated"));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)"ModelBus Description Validation", (String)e.getMessage());
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public void setActiveEditor(IEditorPart editorPart) {
        if (editorPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)editorPart).getEditingDomain();
        }
    }

    public EList getModel() {
        Resource resource = (Resource)this.domain.getResourceSet().getResources().get(0);
        if (resource != null) {
            return resource.getContents();
        }
        return null;
    }
}

