/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.abstract_.DirectionKind;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.InputHolder;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.OutputHolder;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.OutputHolderClass;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.TypeConversion;

public abstract class AbstractGenerator {
    static final String OUTPUT_HOLDER_PREFIX = "OutputHolder_";
    String FILE_POSTFIX = "";
    static final String LICENCE = "/*\n* Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.\n* All rights reserved.\n*\n* This software is published under the terms of the ModelBus Software License\n* in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even\n* the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n* A copy of ModelBus Software License is provided with this distribution in\n* doc/LICENSE.txt file.\n*/\n\n";
    static final String CVS = "/*\n* $RCSfile: $\n* $Date: $\n* $Revision: $\n* $Author: $\n*/\n\n";
    Hashtable outputHolderClasses;
    String packageName;
    String outputDirectory;
    OutputStream fileOs;
    Tool toolDescription;

    public AbstractGenerator(Tool t, OutputStream os) {
        this.outputHolderClasses = new Hashtable();
        this.toolDescription = t;
        this.fileOs = os;
    }

    public AbstractGenerator(Tool t, String outputDirectory) {
        this.outputHolderClasses = new Hashtable();
        this.toolDescription = t;
        this.outputDirectory = outputDirectory;
    }

    public AbstractGenerator() {
    }

    protected void generateHeader() throws IOException {
        this.fileOs.write(CVS.getBytes());
        this.fileOs.write(LICENCE.getBytes());
    }

    protected void generateFileComment() throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("/**\n");
        sb.append(" * " + this.getFileName() + ".java\n");
        sb.append(" *\n");
        sb.append(" * @author auto-generated\n");
        sb.append(" *\n");
        sb.append(" * @version $Revision: $ $Date: $\n");
        sb.append(" **/\n");
        this.fileOs.write(sb.toString().getBytes());
        this.fileOs.write("\n".getBytes());
    }

    protected void generateCode(ModelingServiceInterface msi) throws IOException {
        this.generateImport();
        this.generateFileComment();
        this.generateClassName();
        this.generateConstructor();
        EList services = msi.eContents();
        int i = 0;
        while (i < services.size()) {
            ModelingService ms = (ModelingService)services.get(i);
            this.generateServiceMethods(ms, this.toolDescription.getName(), msi.getName());
            this.fileOs.write("\n".getBytes());
            ++i;
        }
        this.generateAdditionalMethods(msi);
        this.fileOs.write("}\n".getBytes());
    }

    protected void generateOutputHolderFiles(String outputDirectory, String outputPackageName) throws IOException {
        Set outputHolderClassesSet = this.outputHolderClasses.entrySet();
        Iterator iter = outputHolderClassesSet.iterator();
        while (iter.hasNext()) {
            StringBuffer sb = new StringBuffer();
            OutputHolderClass classe = (OutputHolderClass)iter.next().getValue();
            sb.append(LICENCE);
            if (outputPackageName.compareTo("") != 0) {
                sb.append("\npackage " + outputPackageName + ";\n\n");
            }
            sb.append("/**\n");
            sb.append(" * " + classe.getName() + ".java\n");
            sb.append(" *\n");
            sb.append(" * @author auto-generated\n");
            sb.append(" *\n");
            sb.append(" * @version $Revision: 1.5 $ $Date: 2006/06/29 16:46:30 $\n");
            sb.append(" **/\n");
            sb.append("public class ");
            sb.append(classe.getName());
            sb.append(" {\n\n");
            Vector params = classe.getParametres();
            int j = 0;
            while (j < params.size()) {
                Parameter parameter = (Parameter)params.elementAt(j);
                String pName = parameter.getName();
                String pType = TypeConversion.generateType(parameter);
                sb.append("\t/**\n");
                sb.append("\t * " + pType + " " + pName + "\n");
                sb.append("\t **/\n");
                sb.append("\tpublic ");
                sb.append(pType);
                sb.append(" ");
                sb.append(pName);
                sb.append(";\n\n");
                ++j;
            }
            sb.append("}\n");
            File file = new File(String.valueOf(outputDirectory) + File.separator + classe.getName() + ".java");
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(sb.toString().getBytes());
                fos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    protected void generateServiceMethods(ModelingService ms, String ToolName, String ModelingInterfaceName) throws IOException {
    }

    protected void generateAdditionalMethods(ModelingServiceInterface msi) throws IOException {
    }

    protected InputHolder[] createInputHolders(ModelingService ms) {
        EList params = ms.eContents();
        Vector<InputHolder> paramsIN = new Vector<InputHolder>();
        int i = 0;
        while (i < params.size()) {
            Parameter parameter;
            int direction;
            if (params.get(i) instanceof Parameter && ((direction = (parameter = (Parameter)params.get(i)).getDirection().getValue()) == 0 || direction == 2)) {
                paramsIN.add(new InputHolder(parameter));
            }
            ++i;
        }
        InputHolder[] retour = new InputHolder[paramsIN.size()];
        retour = paramsIN.toArray(retour);
        return retour;
    }

    protected String generateInputParameters(InputHolder[] inputHolders) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < inputHolders.length) {
            sb.append(String.valueOf(inputHolders[i].getType()) + " " + inputHolders[i].getName());
            if (i != inputHolders.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected OutputHolder[] createOutputHolders(ModelingService ms) {
        EList params = ms.eContents();
        Vector<Parameter> paramsOUT = new Vector<Parameter>();
        int i = 0;
        while (i < params.size()) {
            if (params.get(i) instanceof Parameter) {
                Parameter parameter = (Parameter)params.get(i);
                int direction = parameter.getDirection().getValue();
                DirectionKind dkind = parameter.getDirection();
                if (direction == 1 || direction == 2 || dkind.getName().equalsIgnoreCase("return")) {
                    paramsOUT.add(parameter);
                }
            }
            ++i;
        }
        if (paramsOUT.size() == 0) {
            OutputHolder[] oh = new OutputHolder[]{new OutputHolder()};
            return oh;
        }
        if (paramsOUT.size() == 1) {
            OutputHolder[] oh = new OutputHolder[]{new OutputHolder((Parameter)paramsOUT.get(0))};
            return oh;
        }
        OutputHolder[] retour = new OutputHolder[paramsOUT.size()];
        String className = OUTPUT_HOLDER_PREFIX + ms.getName();
        OutputHolderClass classeInterne = new OutputHolderClass(className, paramsOUT);
        this.outputHolderClasses.put(className, classeInterne);
        int i2 = 0;
        while (i2 < retour.length) {
            Parameter current = (Parameter)paramsOUT.get(i2);
            retour[i2] = new OutputHolder(className, current);
            ++i2;
        }
        return retour;
    }

    protected String generateOutputParameters(OutputHolder[] outputHolders) {
        if (outputHolders.length == 1) {
            return outputHolders[0].getType();
        }
        return outputHolders[0].getClassName();
    }

    public void generateContent(String outputPackageName, ModelingServiceInterface msi) throws IOException {
        this.generateHeader();
        this.packageName = outputPackageName;
        this.generatePackageDeclaration();
        this.generateCode(msi);
        this.fileOs.close();
    }

    public void generateClassName() throws IOException {
    }

    public void generateConstructor() throws IOException {
    }

    public void generatePackageDeclaration() throws IOException {
        if (this.packageName.compareTo("") != 0) {
            this.fileOs.write(("\npackage " + this.packageName + ";\n\n").getBytes());
        }
    }

    protected void generateImport() throws IOException {
    }

    protected String getFileName() {
        String name = this.toolDescription.getName();
        name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        return String.valueOf(name) + this.FILE_POSTFIX;
    }

    protected String getMethodComment(String methodPrefix, ModelingService ms) {
        String methodName = String.valueOf(methodPrefix) + ms.getName();
        OutputHolder[] outputs = this.createOutputHolders(ms);
        InputHolder[] inputs = this.createInputHolders(ms);
        String outputType = this.generateOutputParameters(outputs);
        String comment = "\n\t/**\n";
        comment = String.valueOf(comment) + "\t *\n";
        comment = String.valueOf(comment) + "\t * ";
        comment = String.valueOf(comment) + methodName;
        comment = String.valueOf(comment) + "\n\t *\n";
        int i = 0;
        while (i < inputs.length) {
            comment = String.valueOf(comment) + "\t * @param " + inputs[i].name + "\n";
            ++i;
        }
        comment = String.valueOf(comment) + "\t * @return " + outputType + " - " + outputs[0].getName() + "\n";
        return comment;
    }

    protected OutputStream getFileOs() {
        if (this.fileOs == null) {
            this.fileOs = this.getOS(this.outputDirectory, this.getFileName());
        }
        return this.fileOs;
    }

    protected OutputStream getOS(String outputDirectory, String fileName) {
        File file = new File(String.valueOf(outputDirectory) + File.separator + fileName + ".java");
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

