/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.AbstractGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.InputHolder;

public class ProviderInterfaceGenerator
extends AbstractGenerator {
    protected static final String EXECUTE_METHOD_PREFIX = "execute_";

    public ProviderInterfaceGenerator(Tool t, OutputStream os) {
        super(t, os);
        this.FILE_POSTFIX = "ProviderInterface";
    }

    public ProviderInterfaceGenerator(Tool tool, String outputDirectory) {
        super(tool, outputDirectory);
        this.FILE_POSTFIX = "ProviderInterface";
        this.fileOs = this.getFileOs();
    }

    protected void generateImport() throws IOException {
        this.fileOs.write("import java.util.Collection;\n".getBytes());
        this.fileOs.write("import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;\n".getBytes());
        this.fileOs.write("import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;\n".getBytes());
        this.fileOs.write("\n".getBytes());
    }

    public void generateClassName() throws IOException {
        this.fileOs.write(("public interface " + this.getFileName() + " {\n").getBytes());
    }

    protected void generateServiceMethods(ModelingService ms, String ToolName, String ModelingInterfaceName) throws IOException {
        String methodName = EXECUTE_METHOD_PREFIX + ms.getName();
        String outputType = this.generateOutputParameters(this.createOutputHolders(ms));
        InputHolder[] inputs = this.createInputHolders(ms);
        String comment = this.getMethodComment(EXECUTE_METHOD_PREFIX, ms);
        comment = String.valueOf(comment) + "\t * @throws ModelingServiceError\n";
        comment = String.valueOf(comment) + "\t * @throws SessionNeeded\n";
        String methodSignature = comment = String.valueOf(comment) + "\t **/\n";
        methodSignature = String.valueOf(methodSignature) + "\tpublic ";
        methodSignature = String.valueOf(methodSignature) + outputType + " ";
        methodSignature = String.valueOf(methodSignature) + methodName;
        methodSignature = String.valueOf(methodSignature) + "(";
        methodSignature = String.valueOf(methodSignature) + this.generateInputParameters(inputs);
        methodSignature = String.valueOf(methodSignature) + ")  throws ModelingServiceError, SessionNeeded;\n\n";
        this.fileOs.write(methodSignature.getBytes());
    }

    public static void main(String[] params) {
        try {
            DescriptionModelLoader loader = new DescriptionModelLoader("OCLTool.description");
            ProviderInterfaceGenerator gen = new ProviderInterfaceGenerator(loader.getTool(), System.out);
            gen.generateContent("some.pack", loader.getModelingServiceInterfaces()[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

