/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType;
import org.eclipse.mddi.modelbus.description.abstract_.Type;

public class TypeConversion {
    public static final String STRING_JAVA = "java.lang.String";
    public static final String BOOLEAN_JAVA = "java.lang.Boolean";
    public static final String INTEGER_JAVA = "java.lang.Integer";
    public static final String DOUBLE_JAVA = "java.lang.Double";
    public static final String COLLECTION_JAVA = "java.util.Collection";
    public static final String BINARY_JAVA = "java.io.InputStream";
    public static final String MULTI_JAVA = "[]";
    public static final String STRING_STRING = "string";
    public static final String BOOLEAN_STRING = "boolean";
    public static final String INTEGER_STRING = "integer";
    public static final String DOUBLE_STRING = "double";
    public static final String BINARY_STRING = "binary";

    public static String convertSinglePrimitive(String string) {
        if (string.equalsIgnoreCase(STRING_STRING)) {
            return STRING_JAVA;
        }
        if (string.equalsIgnoreCase(BOOLEAN_STRING)) {
            return BOOLEAN_JAVA;
        }
        if (string.equalsIgnoreCase(INTEGER_STRING)) {
            return INTEGER_JAVA;
        }
        if (string.equalsIgnoreCase(DOUBLE_STRING)) {
            return DOUBLE_JAVA;
        }
        if (string.equalsIgnoreCase(BINARY_STRING)) {
            return BINARY_JAVA;
        }
        return "// no type found";
    }

    public static String convertMultiPrimitive(String string) {
        if (string.equalsIgnoreCase(STRING_STRING)) {
            return "java.lang.String[]";
        }
        if (string.equalsIgnoreCase(BOOLEAN_STRING)) {
            return "java.lang.Boolean[]";
        }
        if (string.equalsIgnoreCase(INTEGER_STRING)) {
            return "java.lang.Integer[]";
        }
        if (string.equalsIgnoreCase(DOUBLE_STRING)) {
            return "java.lang.Double[]";
        }
        if (string.equalsIgnoreCase(BINARY_STRING)) {
            return "java.io.InputStream[]";
        }
        return "// no type found";
    }

    public static String convertSingleModel() {
        return COLLECTION_JAVA;
    }

    public static String convertMultiModel() {
        return "java.util.Collection[]";
    }

    public static String generateType(Parameter parameter) {
        Type type = parameter.getType();
        if (type instanceof PrimitiveType) {
            if (parameter.getUpper() == -1 || parameter.getUpper() > 1) {
                return TypeConversion.convertMultiPrimitive(type.getName());
            }
            return TypeConversion.convertSinglePrimitive(type.getName());
        }
        if (parameter.getUpper() == -1 || parameter.getUpper() > 1) {
            return TypeConversion.convertMultiModel();
        }
        return TypeConversion.convertSingleModel();
    }
}

