/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.gui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.ProviderInterfaceGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.SkeletonGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.StubGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.EException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ETException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MPException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSIException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MetaSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.PException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ToolException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ToolkitGenerateAction
extends Action {
    protected EditingDomain domain;
    String selectedOutputDirectory;
    String selectedPackageName = "";

    public ToolkitGenerateAction() {
        super("Generate Stubs/Skeletons");
    }

    public void run() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        GenerationDialog dialog = new GenerationDialog(shell);
        dialog.setOutputDirectory(this.selectedOutputDirectory);
        dialog.setOutputPackage(this.selectedPackageName);
        dialog.open();
        this.selectedOutputDirectory = dialog.getOutputDirectory();
        this.selectedPackageName = dialog.getOutputPackage();
        System.out.println("Selected Folder:" + this.selectedOutputDirectory);
        System.out.println("Selected Package:" + this.selectedPackageName);
        try {
            DescriptionModelLoader modelLoader = new DescriptionModelLoader(this.getFile().getLocation().toOSString());
            Validation.globalValidation(modelLoader.getModelBusPackaging());
            System.out.println("Tool description validated");
            StubGenerator.generateAdapter(modelLoader, this.selectedOutputDirectory, this.selectedPackageName);
            System.out.println("Tool Stub Generated");
            ProviderInterfaceGenerator intGen = new ProviderInterfaceGenerator(modelLoader.getTool(), this.selectedOutputDirectory);
            intGen.generateContent(this.selectedPackageName, modelLoader.getModelingServiceInterfaces()[0]);
            System.out.println("Tool Provider Interface Generated");
            SkeletonGenerator skelGen = new SkeletonGenerator(modelLoader.getTool(), this.selectedOutputDirectory);
            skelGen.generateContent(this.selectedPackageName, modelLoader.getModelingServiceInterfaces()[0]);
            System.out.println("Tool Skeleton Generated");
        }
        catch (Exception e) {
            if (e instanceof MetaSException || e instanceof MPException || e instanceof MSIException || e instanceof TException || e instanceof EException || e instanceof ETException || e instanceof NameFormatException || e instanceof MetaSException || e instanceof MSException || e instanceof PException || e instanceof ToolException) {
                MessageDialog.openError((Shell)shell, (String)"ModelBus Description Validation", (String)e.getMessage());
            }
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    protected IFile getFile() {
        Resource resource = (Resource)this.domain.getResourceSet().getResources().get(0);
        if (resource != null) {
            URI uri = resource.getURI();
            uri = resource.getResourceSet().getURIConverter().normalize(uri);
            String scheme = uri.scheme();
            if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
                StringBuffer platformResourcePath = new StringBuffer();
                int j = 1;
                int size = uri.segmentCount();
                while (j < size) {
                    platformResourcePath.append('/');
                    platformResourcePath.append(uri.segment(j));
                    ++j;
                }
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
            }
        }
        return null;
    }

    protected IFile getProjectFolder() {
        ResourcesPlugin.getWorkspace().getRoot().getFullPath();
        Resource resource = (Resource)this.domain.getResourceSet().getResources().get(0);
        if (resource != null) {
            URI uri = resource.getURI();
            uri = resource.getResourceSet().getURIConverter().normalize(uri);
            String scheme = uri.scheme();
            if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
                StringBuffer platformResourcePath = new StringBuffer();
                int j = 1;
                int size = uri.segmentCount();
                while (j < size) {
                    platformResourcePath.append('/');
                    platformResourcePath.append(uri.segment(j));
                    ++j;
                }
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
            }
        }
        return null;
    }

    public void setActiveEditor(IEditorPart editorPart) {
        if (editorPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)editorPart).getEditingDomain();
            this.selectedOutputDirectory = this.getFile().getParent().getLocation().toOSString();
        }
    }

    public EList getModel() {
        Resource resource = (Resource)this.domain.getResourceSet().getResources().get(0);
        if (resource != null) {
            return resource.getContents();
        }
        return null;
    }

    public static class GenerationDialog
    extends Dialog {
        public static int CONTROL_OFFSET = 10;
        protected EditingDomain domain;
        protected Text outputPackageField;
        protected Label outputDirLabel;
        protected String outputDirectory;
        protected String outputPackage;

        public GenerationDialog(Shell parent) {
            this(parent, null);
        }

        public GenerationDialog(Shell parent, EditingDomain domain) {
            super(parent);
            this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
            this.domain = domain;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("ModelBus: Generate Stubs/Skeletons");
        }

        protected Control createDialogArea(Composite parent) {
            boolean resourcesBundleIsAvailable = Platform.getBundle((String)"org.eclipse.core.resources") != null;
            Composite composite = (Composite)super.createDialogArea(parent);
            FormLayout layout = new FormLayout();
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            if (!resourcesBundleIsAvailable) {
                data.widthHint = 330;
            }
            composite.setLayoutData((Object)data);
            this.outputDirLabel = new Label(composite, 16384);
            this.outputDirLabel.setText("Output Directory:" + this.outputDirectory);
            FormData data2 = new FormData();
            data2.top = new FormAttachment(0, CONTROL_OFFSET);
            data2.left = new FormAttachment(0, CONTROL_OFFSET);
            data2.right = new FormAttachment(100, -CONTROL_OFFSET);
            this.outputDirLabel.setLayoutData((Object)data2);
            Button resourceURIBrowseFileSystemButton = new Button(composite, 8);
            resourceURIBrowseFileSystemButton.setText("Change...");
            resourceURIBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ GenerationDialog this$1;
                {
                    this.this$1 = generationDialog;
                }

                public void widgetSelected(SelectionEvent event) {
                    DirectoryDialog dirDialog = new DirectoryDialog(this.this$1.getShell());
                    String msg = "Please, select folder for generated subs/skeletons";
                    dirDialog.setMessage(msg);
                    dirDialog.setFilterPath(this.this$1.outputDirectory);
                    dirDialog.open();
                    this.this$1.outputDirectory = dirDialog.getFilterPath();
                    this.this$1.outputDirLabel.setText("Output Directory:" + this.this$1.outputDirectory);
                }
            });
            data = new FormData();
            data.right = new FormAttachment(100, -CONTROL_OFFSET);
            data.top = new FormAttachment((Control)this.outputDirLabel, CONTROL_OFFSET);
            resourceURIBrowseFileSystemButton.setLayoutData((Object)data);
            Label outputPackageLabel = new Label(composite, 16384);
            outputPackageLabel.setText("Output Package:");
            FormData data3 = new FormData();
            data3.top = new FormAttachment((Control)resourceURIBrowseFileSystemButton, CONTROL_OFFSET);
            data3.left = new FormAttachment(0, CONTROL_OFFSET);
            data3.right = new FormAttachment(100, -CONTROL_OFFSET);
            data3.left = new FormAttachment(0, CONTROL_OFFSET);
            outputPackageLabel.setLayoutData((Object)data3);
            this.outputPackageField = new Text(composite, 2048);
            data3 = new FormData();
            data3.top = new FormAttachment((Control)outputPackageLabel, CONTROL_OFFSET);
            data3.left = new FormAttachment(0, CONTROL_OFFSET);
            data3.right = new FormAttachment(100, -CONTROL_OFFSET);
            this.outputPackageField.setLayoutData((Object)data3);
            this.outputPackageField.setText(this.outputPackage);
            Label separatorLabel = new Label(composite, 258);
            FormData data4 = new FormData();
            data4.top = new FormAttachment((Control)this.outputPackageField, (int)(1.5 * (double)CONTROL_OFFSET));
            data4.left = new FormAttachment(0, -CONTROL_OFFSET);
            data4.right = new FormAttachment(100, CONTROL_OFFSET);
            separatorLabel.setLayoutData((Object)data4);
            composite.setTabList(new Control[]{this.outputPackageField, resourceURIBrowseFileSystemButton});
            return composite;
        }

        protected void okPressed() {
            this.outputPackage = this.outputPackageField.getText();
            super.okPressed();
        }

        protected synchronized String getOutputDirectory() {
            return this.outputDirectory;
        }

        protected synchronized void setOutputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
        }

        protected synchronized String getOutputPackage() {
            return this.outputPackage;
        }

        protected synchronized void setOutputPackage(String outputPackage) {
            this.outputPackage = outputPackage;
        }
    }
}

