/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet.ImplTemplate;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet.InterfaceTemplate;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet.ProviderTemplate;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet.StubTemplate;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet.WSDLModelingInterfaceTemplate;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;

/**
 * 
 * Console front end of the generator
 * 
 * @author Alexis Muller
 *  
 */
public class Toolkit
{

    /**
     * String HELP_OPTION : String for the help option
     */
    protected static final String HELP_OPTION = "-help";

    /**
     * String OUTPUT_DIRECTORY_OPTION : String for the output directory option
     */
    protected static final String OUTPUT_DIRECTORY_OPTION = "-directory";

    /**
     * String OUTPUT_PACKAGE_OPTION : String for the output package option
     */
    protected static final String OUTPUT_PACKAGE_OPTION = "-package";
    
    protected static final String JAVADOC_OPTION = "-javadoc";
    public static boolean javadoc = false;
    
    protected static final String PROVIDER_OPTION = "-provider";
    public static boolean provider = false;
    
    protected static final String STUB_OPTION = "-stub";
    public static boolean stub = false;
    
    protected static final String IMPL_OPTION = "-impl";
    public static boolean impl = false;
    
    protected static final String ASYNC_OPTION = "-async";
    public static boolean async = false;
    
    protected static final String WSDL_OPTION = "-wsdl";
    public static boolean wsdl = false;
    
    protected static String outputDirectory;
    protected static String outputPackage;
    
    protected static String filelocation; //che

	// che
    public Toolkit() {
    	filelocation="";
    	outputDirectory = ".";
    	outputPackage = "";
    }

    /**
     * 
     * Main method for the console mode of the ToolKit
     * 
     * @param args
     *            The parameter of this program
     *  
     */
    public static void main(String[] args)
    {
		try
		{
			Hashtable arguments = new Hashtable();

			for(int i = 1; i < args.length; i++)
			{
				if(args[i].compareTo(OUTPUT_DIRECTORY_OPTION) == 0 ||
				   args[i].compareTo(OUTPUT_PACKAGE_OPTION) == 0)
				{
					arguments.put(args[i], args[i + 1]);
					i++;
				}
				else if (args[i].equals(JAVADOC_OPTION))
					javadoc = true;
				else if (args[i].equals(IMPL_OPTION))
					impl = true;
				else if (args[i].equals(PROVIDER_OPTION))
					provider = true;
				else if (args[i].equals(STUB_OPTION))
					stub = true;
				else if (args[i].equals(ASYNC_OPTION))
					async = true;
				else if (args[i].equals(WSDL_OPTION))
					wsdl = true;
				else
				{
					throw new Exception();
				}
			}

			String fileName = args[0];
			outputDirectory = (String)arguments.get(OUTPUT_DIRECTORY_OPTION);
			outputPackage = (String)arguments.get(OUTPUT_PACKAGE_OPTION);
			
			if(outputDirectory == null)
				outputDirectory = ".";
			
			if(outputPackage == null)
				outputPackage = "";
			
			
			DescriptionModelLoader modelLoader = new DescriptionModelLoader(fileName);
			Validation.globalValidation(modelLoader.getModelBusPackaging());
			System.out.println("Tool description validated");
	
			generateSources (modelLoader);
		}
		catch (Exception e)
		{		
			printHelp();
			System.err.println(e.getMessage());
		}
	}
    
    //che
    public void generateSources() {
    	try {
		DescriptionModelLoader modelLoader = new DescriptionModelLoader(filelocation);
		Validation.globalValidation(modelLoader.getModelBusPackaging());
		modelLoader.setOutputPackage(outputPackage);
		generateSources (modelLoader);
    	} catch (Exception e)
    	{
    		e.printStackTrace();
    	}
	}

    public static void generateSources (DescriptionModelLoader modelLoader)
    {
    	try
		{
    		// Interfaces
    		InterfaceTemplate interfaceTemplate = new InterfaceTemplate();
    		for (ModelingServiceInterface msi : modelLoader.getModelingServiceInterfaces())
    		{
    			File file = new File(outputDirectory +
				     File.separator +
				     msi.getName() + ".java");
    			List<Object> values = new ArrayList();
    			values.add(outputPackage);
    			values.add(msi);
    			FileOutputStream fos = new FileOutputStream(file);
    			fos.write(interfaceTemplate.generate(values).getBytes());
    			fos.close();
    		}
    		System.out.println("Interfaces Generated");
		
    		// Implementation
    		if (impl)
    		{
    			ImplTemplate implTemplate = new ImplTemplate();
    			File file = new File(outputDirectory +
				     File.separator +
				     modelLoader.getTool().getName() + "Impl.java");

    			FileOutputStream fos = new FileOutputStream(file);
    			fos.write(implTemplate.generate(modelLoader).getBytes());
    			fos.close();

    			System.out.println("Impl Generated");
    		}

    		// Provider
    		if (provider)
    		{
    			ProviderTemplate providerTemplate = new ProviderTemplate();
    			File file = new File(outputDirectory +
				     File.separator +
				     modelLoader.getTool().getName() + "Provider.java");

    			FileOutputStream fos = new FileOutputStream(file);
    			fos.write(providerTemplate.generate(modelLoader).getBytes());
    			fos.close();

    			System.out.println("Provider Generated");
    		}
		
    		// Stub
    		if (stub)
    		{
    			StubTemplate providerTemplate = new StubTemplate();
    			File file = new File(outputDirectory +
				     File.separator +
				     modelLoader.getTool().getName() + ".java");

    			FileOutputStream fos = new FileOutputStream(file);
    			fos.write(providerTemplate.generate(modelLoader).getBytes());
    			fos.close();

    			System.out.println("Stub Generated");
    		}
    		
    		// wsdl
				if (wsdl)
				{
					WSDLModelingInterfaceTemplate wsdlTemplate  = new WSDLModelingInterfaceTemplate();
					File file = new File(outputDirectory +
						     File.separator +
						     modelLoader.getTool().getName() + ".wsdl");
		
					FileOutputStream fos = new FileOutputStream(file);
					fos.write(wsdlTemplate.generate(modelLoader).getBytes());
					fos.close();

					System.out.println("WSDL Generated");
				}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
    }
    /**
     * Print the help message
     */
    protected static void printHelp() {
        System.out
                .println("Usage: java -classpath \"path_to_org.eclipse.mddi.modelbus.toolkit.jar\" "
                        + "org.eclipse.mddi.modelbus.toolkit.Toolkit \"path_to_myTool.description\" [-options]\n"
                        + "\n"
                        + "where options include:\n"
                        + "\t"
                        + OUTPUT_DIRECTORY_OPTION
                        + "\tto specify an existing output directory for the generated files\n"
                        + "\t"
                        + OUTPUT_PACKAGE_OPTION
                        + "\tto specify the package name for the generated files\n"
                        + "\t"
                        + HELP_OPTION
                        + "\t\tto print this message\n"
                        + "\t"
                        + PROVIDER_OPTION
                        + "\tto generate the service provider class\n"
                        + "\t"
                        + STUB_OPTION
                        + "\t\tto generate the service stub class\n"
                        + "\t"
                        + IMPL_OPTION
                        + "\t\tto generate the service implementaiton skeleton\n"
                        + "\t"
                        + JAVADOC_OPTION
                        + "\tto generate javadoc template in generated files\n"
                        + "\n"
                        + WSDL_OPTION
                        + "\tto generate the WSDL service definition\n"
                        + "\n"
                        + "For further help please see the user manual\n");
    }

    //che
    public void SetOutputDirectory(String directory) {
    	outputDirectory = directory;
    }
    
    //che
    public void SetOutputPackage(String packagename) {
    	outputPackage = packagename;
    }
    
    //che
    public void SetDescriptionFileLocation(String location) {
    	filelocation = location;
    }
    
    //che
    public void SetProvider(boolean value) {
    	provider=value;
    }
    
    //che
    public void SetStub(boolean value) {
    	stub=value;
    }
    
    //che
    public void SetImpl(boolean value) {
    	impl=value;
    }
    
    //che
    public void SetJavaDoc(boolean value) {
    	javadoc=value;
    }

}
