
package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType;
import org.eclipse.mddi.modelbus.description.abstract_.Type;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.exception.BadModeException;

/**
 * Class for the equivalence of the types
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner, Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel, Alexis Muller
 *
 */
public class TypeConversion {
	
	/**
	 * String STRING_JAVA
	 */
	public static final String STRING_JAVA = "java.lang.String";
	
	/**
	 * String BOOLEAN_JAVA
	 */
	public static final String BOOLEAN_JAVA="java.lang.Boolean";
	
	/**
	 * String INTEGER_JAVA
	 */
	public static final String INTEGER_JAVA="java.lang.Integer";
	
	/**
	 * String DOUBLE_JAVA
	 */
	public static final String DOUBLE_JAVA="java.lang.Double";
	
	/**
	 * String COLLECTION_JAVA
	 */
	public static final String COLLECTION_JAVA ="java.util.Collection";

	public static final String MULTI_JAVA ="java.util.ArrayList";
	/**
	 * String BINARY_JAVA
	 */
	public static final String BINARY_JAVA ="java.io.InputStream";
	
	/**
	 * String STRING_STRING
	 */
	public static final String STRING_STRING="string";
	
	/**
	 * String BOOLEAN_STRING
	 */
	public static final String BOOLEAN_STRING="boolean";
	
	/**
	 * String INTEGER_STRING
	 */
	public static final String INTEGER_STRING="integer";
	
	/**
	 * String DOUBLE_STRING
	 */
	public static final String DOUBLE_STRING="double";

	/**
	 * String BINARY_STRING
	 */
	public static final String BINARY_STRING="binary";
	
	public static final String UML_STRING="uml.";
	public static final String UML_JAVA="org.eclipse.uml2.";
	
	/**
	 * Convert the primitive types
	 * 
	 * @param string The string to convert
	 * @return String The correct type
	 */
	public static String convertSinglePrimitive(String string){
		if (string.equalsIgnoreCase(STRING_STRING)) return STRING_JAVA;
		if (string.equalsIgnoreCase(BOOLEAN_STRING)) return BOOLEAN_JAVA;
		if (string.equalsIgnoreCase(INTEGER_STRING)) return INTEGER_JAVA;
		if (string.equalsIgnoreCase(DOUBLE_STRING)) return DOUBLE_JAVA;
		if (string.equalsIgnoreCase(BINARY_STRING)) return BINARY_JAVA;
		return "// no type found";
		
	}
	
	/**
	 * Convert the primtive types for an array
	 * 
	 * @param string The string to convert
	 * @return String The correct type
	 */
	public static String convertMultiPrimitive(String string){
		if (string.equalsIgnoreCase(STRING_STRING)) return MULTI_JAVA + "<" + STRING_JAVA + ">";
		if (string.equalsIgnoreCase(BOOLEAN_STRING)) return MULTI_JAVA + "<" + BOOLEAN_JAVA + ">";
		if (string.equalsIgnoreCase(INTEGER_STRING)) return MULTI_JAVA + "<" + INTEGER_JAVA + ">";
		if (string.equalsIgnoreCase(DOUBLE_STRING)) return MULTI_JAVA + "<" + DOUBLE_JAVA + ">";
		if (string.equalsIgnoreCase(BINARY_STRING)) return MULTI_JAVA + "<" + BINARY_JAVA + ">";
		return "// no type found";
		
	}
	
	/**
	 * Return the type for a model
	 * 
	 * @return String The correct type
	 */
	public static String convertSingleModel(String string){
		if (string.substring(0, 4).equalsIgnoreCase(UML_STRING))
			return UML_JAVA + string;
		return COLLECTION_JAVA;
	}
	
	/**
	 * Return the type for an array of models
	 * 
	 * @return String The correct type
	 */
	public static String convertMultiModel(){
		return COLLECTION_JAVA;
	}
	
	public static boolean isPrimitive (Parameter parameter) {
		Type type = parameter.getType();
		return type instanceof PrimitiveType;
	}

	/**
	 * Generate the type
	 * 
	 * @param parameter The parameter
	 * @return String The correct type
	 */
	public static String generateType(Parameter parameter) {
		Type type = parameter.getType();
		
		if(type instanceof PrimitiveType){ // PrimitiveType
			if(parameter.getUpper() == -1 || parameter.getUpper() > 1) {
				return TypeConversion.convertMultiPrimitive(type.getName());
			}
			return TypeConversion.convertSinglePrimitive(type.getName());
		}
		/*if(parameter.getUpper() == -1 || parameter.getUpper() > 1) {
			return TypeConversion.convertMultiModel();
		}*/
		return TypeConversion.convertSingleModel(type.getName());
	}
	
	public static String generateTypeCreation(Parameter parameter) {
		Type type = parameter.getType();
		
		if(type instanceof PrimitiveType){ // PrimitiveType
			/*if(parameter.getUpper() == -1 || parameter.getUpper() > 1) {
				return TypeConversion.convertMultiPrimitive(type.getName());
			}*/
			return "new " + TypeConversion.convertSinglePrimitive(type.getName());
		}
		if(parameter.getUpper() == -1 || parameter.getUpper() > 1) {
			return "new Vector";
		}
		
		if (type.getName().substring(0, 4).equalsIgnoreCase(UML_STRING))
			return UML_JAVA + "uml.UMLFactory.eINSTANCE.create" + type.getName().substring(4);
		
		return "EMFFactory.eINSTANCE.create" + type.getName();
	}
}
