
package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType;
import org.eclipse.mddi.modelbus.description.abstract_.Type;

/**
 * Class for the equivalence of the types
 * 
 * @author Xavier Blanc
 *
 */
public class TypeConversion4XMLSchema {
	
	/**
	 * String STRING_XMLSchema
	 */
	public static final String STRING_XMLSchema = "type=\"xsd:string\"";
	
	/**
	 * String BOOLEAN_XMLSchema
	 */
	public static final String BOOLEAN_XMLSchema="type=\"xsd:boolean\"";
	
	/**
	 * String INTEGER_XMLSchema
	 */
	public static final String INTEGER_XMLSchema="type=\"xsd:integer\"";
	
	/**
	 * String DOUBLE_XMLSchema
	 */
	public static final String DOUBLE_XMLSchema="type=\"xsd:double\"";
	
	/**
	 * String BINARY_XMLSchema
	 */
	public static final String BINARY_XMLSchema ="type=\"cdata\"";
	
	/**
	 * String MODEL_XMLSchema
	 */
	public static final String MODEL_XMLSchema ="element=\"mbns:model\"";
	
	
	///////////////SETS
	
	
	
	/**
	 * String STRING_SET_XMLSchema
	 */
	public static final String STRING_SET_XMLSchema = "element=\"mbns:stringset\"";
	
	/**
	 * String BOOLEAN_XMLSchema
	 */
	public static final String BOOLEAN_SET_XMLSchema= "element=\"mbns:booleanset\"";
	
	/**
	 * String INTEGER_XMLSchema
	 */
	public static final String INTEGER_SET_XMLSchema= "element=\"mbns:integerset\"";
	
	/**
	 * String DOUBLE_XMLSchema
	 */
	public static final String DOUBLE_SET_XMLSchema="element=\"mbns:doubleset\"";
	
	/**
	 * String BINARY_XMLSchema
	 */
	public static final String BINARY_SET_XMLSchema ="type=\"cdata\"";
	
	/**
	 * String MODEL_SET_XMLSchema
	 */
	public static final String MODEL_SET_XMLSchema ="element=\"mbns:modelset\"";
	
	
	
	/**
	 * String STRING_STRING
	 */
	public static final String STRING_STRING="string";
	
	/**
	 * String BOOLEAN_STRING
	 */
	public static final String BOOLEAN_STRING="boolean";
	
	/**
	 * String INTEGER_STRING
	 */
	public static final String INTEGER_STRING="integer";
	
	/**
	 * String DOUBLE_STRING
	 */
	public static final String DOUBLE_STRING="double";

	/**
	 * String BINARY_STRING
	 */
	public static final String BINARY_STRING="binary";
	
	public static final String UML_STRING="uml.";
	public static final String UML_JAVA="org.eclipse.uml2.";
	
	/**
	 * Convert the primitive types
	 * 
	 * @param string The string to convert
	 * @return String The correct type
	 */
	public static String convertSinglePrimitive(String string){
		if (string.equalsIgnoreCase(STRING_STRING)) return STRING_XMLSchema;
		if (string.equalsIgnoreCase(BOOLEAN_STRING)) return BOOLEAN_XMLSchema;
		if (string.equalsIgnoreCase(INTEGER_STRING)) return INTEGER_XMLSchema;
		if (string.equalsIgnoreCase(DOUBLE_STRING)) return DOUBLE_XMLSchema;
		if (string.equalsIgnoreCase(BINARY_STRING)) return BINARY_XMLSchema;
		return "// no type found";
		
	}
	
	/**
	 * Convert the primtive types for an array
	 * 
	 * @param string The string to convert
	 * @return String The correct type
	 */
	public static String convertMultiPrimitive(String string){
		if (string.equalsIgnoreCase(STRING_STRING)) return STRING_SET_XMLSchema;
		if (string.equalsIgnoreCase(BOOLEAN_STRING)) return BOOLEAN_SET_XMLSchema;
		if (string.equalsIgnoreCase(INTEGER_STRING)) return INTEGER_SET_XMLSchema;
		if (string.equalsIgnoreCase(DOUBLE_STRING)) return DOUBLE_SET_XMLSchema;
		if (string.equalsIgnoreCase(BINARY_STRING)) return BINARY_SET_XMLSchema;
		return "// no type found";
		
	}
	
	/**
	 * Return the type for a model
	 * 
	 * @return String The correct type
	 */
	public static String convertSingleModel(String string){
		//if (string.substring(0, 4).equalsIgnoreCase(UML_STRING))
		//	return UML_JAVA + string;
		return MODEL_XMLSchema;
	}
	
	/**
	 * Return the type for an array of models
	 * 
	 * @return String The correct type
	 */
	public static String convertMultiModel(){
		return MODEL_SET_XMLSchema;
	}
	
	public static boolean isPrimitive (Parameter parameter) {
		Type type = parameter.getType();
		return type instanceof PrimitiveType;
	}

	/**
	 * Generate the type
	 * 
	 * @param parameter The parameter
	 * @return String The correct type
	 */
	public static String generateType(Parameter parameter) {
		Type type = parameter.getType();
		
		if(type instanceof PrimitiveType){ // PrimitiveType
			if(parameter.getUpper() == -1 || parameter.getUpper() > 1) {
				return TypeConversion4XMLSchema.convertMultiPrimitive(type.getName());
			}
			return TypeConversion4XMLSchema.convertSinglePrimitive(type.getName());
		}
		if(parameter.getUpper() == -1 || parameter.getUpper() > 1) {
			return TypeConversion4XMLSchema.convertMultiModel();
		}
		return TypeConversion4XMLSchema.convertSingleModel(type.getName());
	}
}
