package org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet;

import java.util.*;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.description.abstract_.*;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.TypeConversion;
import org.eclipse.mddi.modelbus.toolkit.Toolkit;

public class ImplTemplate
{
  protected static String nl;
  public static synchronized ImplTemplate create(String lineSeparator)
  {
    nl = lineSeparator;
    ImplTemplate result = new ImplTemplate();
    nl = null;
    return result;
  }

  public final String NL = nl == null ? (System.getProperties().getProperty("line.separator")) : nl;
  protected final String TEXT_1 = "/*" + NL + "* Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus." + NL + "* All rights reserved." + NL + "*" + NL + "* This software is published under the terms of the ModelBus Software License" + NL + "* in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even" + NL + "* the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE." + NL + "* A copy of ModelBus Software License is provided with this distribution in" + NL + "* doc/LICENSE.txt file." + NL + "*/" + NL;
  protected final String TEXT_2 = NL + "package ";
  protected final String TEXT_3 = ";";
  protected final String TEXT_4 = NL + NL + NL + "import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;" + NL;
  protected final String TEXT_5 = NL + "/**" + NL + " * @author " + NL + " * " + NL + " * " + NL + " */";
  protected final String TEXT_6 = NL + "public class ";
  protected final String TEXT_7 = "Impl implements ";
  protected final String TEXT_8 = ",";
  protected final String TEXT_9 = NL + "{";
  protected final String TEXT_10 = NL + "\t// ";
  protected final String TEXT_11 = " interface";
  protected final String TEXT_12 = "   \t" + NL + "\tpublic ";
  protected final String TEXT_13 = " ";
  protected final String TEXT_14 = "(";
  protected final String TEXT_15 = ")" + NL + "   \t       throws ModelBusCommunicationException, ServiceUnknownException," + NL + "   \t              NoToolAvailableException, ModelTypeMismatchException {" + NL + "   \t              // TODO : Put your implementation code here" + NL + "\t}" + NL + "\t";
  protected final String TEXT_16 = "\t" + NL + "}";
  protected final String TEXT_17 = NL;

  public String generate(Object argument)
  {
    final StringBuffer stringBuffer = new StringBuffer();
     DescriptionModelLoader modelLoader = (DescriptionModelLoader) argument; 
    stringBuffer.append(TEXT_1);
     if (modelLoader.getOutputPackage()!="") {

    stringBuffer.append(TEXT_2);
    stringBuffer.append(modelLoader.getOutputPackage());
    stringBuffer.append(TEXT_3);
     }
    stringBuffer.append(TEXT_4);
     if (Toolkit.javadoc) { 
    stringBuffer.append(TEXT_5);
     } 
    stringBuffer.append(TEXT_6);
    stringBuffer.append(modelLoader.getTool().getName());
    stringBuffer.append(TEXT_7);
     for (int i = 0; i < modelLoader.getModelingServiceInterfaces().length; i++) {
ModelingServiceInterface msi =  (ModelingServiceInterface) modelLoader.getModelingServiceInterfaces()[i];

    stringBuffer.append(msi.getName());
    
if (i < modelLoader.getModelingServiceInterfaces().length - 1)
    stringBuffer.append(TEXT_8);
    
} 
    stringBuffer.append(TEXT_9);
    for (ModelingServiceInterface msi : modelLoader.getModelingServiceInterfaces()) {
    stringBuffer.append(TEXT_10);
    stringBuffer.append(msi.getName());
    stringBuffer.append(TEXT_11);
     for (Iterator i = msi.getService().iterator(); i.hasNext();) {
	     ModelingService service = (ModelingService) i.next();
	
	String ret = "void";
    String params = "";
    
    for (Iterator it = service.getParameter().iterator(); it.hasNext();) {
        Parameter param = (Parameter) it.next();
   	    if (param.getDirection() == DirectionKind.RETURN_LITERAL)
   	       ret = TypeConversion.generateType(param);
   	    else
   	    {
   	       if (!params.equals(""))
   	           params += ", ";
   	       params += TypeConversion.generateType(param) + " " + param.getName();
   	    }
   	} 	
 
    stringBuffer.append(TEXT_12);
    stringBuffer.append(ret);
    stringBuffer.append(TEXT_13);
    stringBuffer.append(service.getName());
    stringBuffer.append(TEXT_14);
    stringBuffer.append(params);
    stringBuffer.append(TEXT_15);
     }
 } 
    stringBuffer.append(TEXT_16);
    stringBuffer.append(TEXT_17);
    return stringBuffer.toString();
  }
}
