package org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet;

import java.util.*;
import org.eclipse.mddi.modelbus.description.abstract_.*;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.TypeConversion;
import org.eclipse.mddi.modelbus.toolkit.Toolkit;

public class InterfaceTemplate
{
  protected static String nl;
  public static synchronized InterfaceTemplate create(String lineSeparator)
  {
    nl = lineSeparator;
    InterfaceTemplate result = new InterfaceTemplate();
    nl = null;
    return result;
  }

  public final String NL = nl == null ? (System.getProperties().getProperty("line.separator")) : nl;
  protected final String TEXT_1 = "\t";
  protected final String TEXT_2 = NL + "/*" + NL + "* Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus." + NL + "* All rights reserved." + NL + "*" + NL + "* This software is published under the terms of the ModelBus Software License" + NL + "* in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even" + NL + "* the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE." + NL + "* A copy of ModelBus Software License is provided with this distribution in" + NL + "* doc/LICENSE.txt file." + NL + "*/" + NL;
  protected final String TEXT_3 = NL + "package ";
  protected final String TEXT_4 = ";";
  protected final String TEXT_5 = NL + NL + "import java.util.Collection;" + NL + "import java.util.Properties;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;" + NL + "import org.eclipse.mddi.modelbus.adapter.infrastructure.DeploymentException;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;" + NL + "import org.eclipse.uml2.uml.Package;" + NL;
  protected final String TEXT_6 = NL + "/**" + NL + " * ";
  protected final String TEXT_7 = ".java" + NL + " *" + NL + " * @author auto-generated" + NL + " *" + NL + " * @version $Revision: 1.4 $" + NL + " **/";
  protected final String TEXT_8 = NL + "public interface ";
  protected final String TEXT_9 = " {" + NL + "\t" + NL + "\t";
  protected final String TEXT_10 = NL + "\t/**" + NL + "\t *" + NL + "\t * ";
  protected final String TEXT_11 = NL + "\t * ";
  protected final String TEXT_12 = NL + "\t * ";
  protected final String TEXT_13 = "@return ";
  protected final String TEXT_14 = "@param ";
  protected final String TEXT_15 = " ";
  protected final String TEXT_16 = NL + "\t * @throws ModelBusCommunicationException" + NL + "\t * @throws ServiceUnknownException" + NL + "\t * @throws NoToolAvailableException" + NL + "\t * @throws ModelTypeMismatchException" + NL + "\t **/" + NL + "\t";
  protected final String TEXT_17 = "   \t" + NL + "\tpublic ";
  protected final String TEXT_18 = " ";
  protected final String TEXT_19 = "(";
  protected final String TEXT_20 = ")" + NL + "   \t       throws ModelBusCommunicationException, ServiceUnknownException," + NL + "   \t              NoToolAvailableException, ModelTypeMismatchException;" + NL + "" + NL + "\t";
  protected final String TEXT_21 = NL + "}";
  protected final String TEXT_22 = NL;

  public String generate(Object argument)
  {
    final StringBuffer stringBuffer = new StringBuffer();
     List<Object> values = (List<Object>)argument; 
    	String packagename=(String)values.get(0); 
    stringBuffer.append(TEXT_1);
     ModelingServiceInterface inter = (ModelingServiceInterface) values.get(1); 
    stringBuffer.append(TEXT_2);
     if (packagename!="") {

    stringBuffer.append(TEXT_3);
    stringBuffer.append(packagename);
    stringBuffer.append(TEXT_4);
     }
    stringBuffer.append(TEXT_5);
     if (Toolkit.javadoc) { 
    stringBuffer.append(TEXT_6);
    stringBuffer.append(inter.getName());
    stringBuffer.append(TEXT_7);
     } 
    stringBuffer.append(TEXT_8);
    stringBuffer.append(inter.getName());
    stringBuffer.append(TEXT_9);
     for (Iterator i = inter.getService().iterator(); i.hasNext();) {
	     ModelingService service = (ModelingService) i.next();
	   if (Toolkit.javadoc) { 
    stringBuffer.append(TEXT_10);
    stringBuffer.append(service.getName());
    stringBuffer.append(TEXT_11);
     for (Iterator it = service.getParameter().iterator(); it.hasNext();) {
	        Parameter param = (Parameter) it.next();
    stringBuffer.append(TEXT_12);
     if (param.getDirection() == DirectionKind.RETURN_LITERAL) 
    stringBuffer.append(TEXT_13);
     else 
    stringBuffer.append(TEXT_14);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_15);
     } 
    stringBuffer.append(TEXT_16);
     } 
      String ret = "void";
    String params = "";
    
    for (Iterator it = service.getParameter().iterator(); it.hasNext();) {
        Parameter param = (Parameter) it.next();
   	    if (param.getDirection() == DirectionKind.RETURN_LITERAL)
   	       ret = TypeConversion.generateType(param);
   	    else
   	    {
   	       if (!params.equals(""))
   	           params += ", ";
   	       params += TypeConversion.generateType(param) + " " + param.getName();
   	    }
   	} 	
 
    stringBuffer.append(TEXT_17);
    stringBuffer.append(ret);
    stringBuffer.append(TEXT_18);
    stringBuffer.append(service.getName());
    stringBuffer.append(TEXT_19);
    stringBuffer.append(params);
    stringBuffer.append(TEXT_20);
     } 
    stringBuffer.append(TEXT_21);
    stringBuffer.append(TEXT_22);
    return stringBuffer.toString();
  }
}
