package org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet;

import java.util.*;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.TypeConversion;
import org.eclipse.mddi.modelbus.description.abstract_.*;
import org.eclipse.mddi.modelbus.toolkit.Toolkit;

public class ProviderTemplate
{
  protected static String nl;
  public static synchronized ProviderTemplate create(String lineSeparator)
  {
    nl = lineSeparator;
    ProviderTemplate result = new ProviderTemplate();
    nl = null;
    return result;
  }

  public final String NL = nl == null ? (System.getProperties().getProperty("line.separator")) : nl;
  protected final String TEXT_1 = "/*" + NL + "* Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus." + NL + "* All rights reserved." + NL + "*" + NL + "* This software is published under the terms of the ModelBus Software License" + NL + "* in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even" + NL + "* the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE." + NL + "* A copy of ModelBus Software License is provided with this distribution in" + NL + "* doc/LICENSE.txt file." + NL + "*/" + NL;
  protected final String TEXT_2 = NL + "package ";
  protected final String TEXT_3 = ";";
  protected final String TEXT_4 = NL + NL + "import java.util.Collection;" + NL + "import java.util.Map;" + NL + "import java.util.Properties;" + NL + "" + NL + "import org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainerImpl;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider2;" + NL;
  protected final String TEXT_5 = NL + "/**" + NL + " * " + NL + " * " + NL + " * @author " + NL + " *  " + NL + " */";
  protected final String TEXT_6 = NL + "public class ";
  protected final String TEXT_7 = "Provider implements GenericProvider2" + NL + "{" + NL + "    public static boolean isStarted = false;" + NL + "    " + NL + "    protected ";
  protected final String TEXT_8 = "Impl service = new ";
  protected final String TEXT_9 = "Impl();" + NL + "    " + NL + "    public static void main(String args[])" + NL + "    {" + NL + "        if(isStarted) return;" + NL + "        " + NL + "        if (args.length < 2)" + NL + "        {" + NL + "        \tSystem.err.println(\"Usage : java ";
  protected final String TEXT_10 = "Provider registryURL servicefile.description\");" + NL + "        \tSystem.exit(0);" + NL + "        }" + NL + "        " + NL + "        String registry_loc = args[0];" + NL + "        String desc_file = args[1];" + NL + "        " + NL + "        // initialize UML2 metamodel" + NL + "        org.eclipse.uml2.uml.UMLPackage.eINSTANCE.getUMLFactory();" + NL + "        " + NL + "        try" + NL + "        {    " + NL + "            Properties p = new Properties();" + NL + "            " + NL + "            p.put(AdapterStub.PROP_REGISTRY_LOCATION, registry_loc);" + NL + "            p.put(AdapterStub.PROP_TOOL_DESC_FILE , desc_file);            " + NL + "            AdapterStub adapter = new AdapterStubImpl(p);" + NL + "" + NL + "            adapter.getToolStub().setProvider2(new ";
  protected final String TEXT_11 = "Provider());" + NL + "" + NL + "            System.out.println(\"Deploying Adapter\");" + NL + "" + NL + "            AdapterContainerImpl.getInstance().deployAdapter(adapter);" + NL + "            " + NL + "            System.out.println(\"Provider tool is available\");" + NL + "        }" + NL + "        catch (Exception e)" + NL + "        {" + NL + "            e.printStackTrace();" + NL + "            System.exit(0);            " + NL + "        }" + NL + "    }" + NL + "    " + NL + "" + NL + "    public Map execute(String serviceName, Map parameterValues)" + NL + "            throws SessionNeeded, ModelingServiceError" + NL + "    {" + NL + "    \ttry" + NL + "        {";
  protected final String TEXT_12 = NL + "\t\t// ";
  protected final String TEXT_13 = " interface";
  protected final String TEXT_14 = NL + "\t\t" + NL + "            if (serviceName.equalsIgnoreCase(\"";
  protected final String TEXT_15 = "\"))" + NL + "            {";
  protected final String TEXT_16 = NL + "            \t";
  protected final String TEXT_17 = "  ";
  protected final String TEXT_18 = " = (";
  protected final String TEXT_19 = ") parameterValues.get(\"";
  protected final String TEXT_20 = "\");";
  protected final String TEXT_21 = NL + "            \t";
  protected final String TEXT_22 = "  ";
  protected final String TEXT_23 = " = (";
  protected final String TEXT_24 = ") ((Collection)parameterValues.get(\"";
  protected final String TEXT_25 = "\")).iterator().next();";
  protected final String TEXT_26 = NL + "                ";
  protected final String TEXT_27 = "  ";
  protected final String TEXT_28 = " =";
  protected final String TEXT_29 = "       " + NL + "         \t    ";
  protected final String TEXT_30 = "  ";
  protected final String TEXT_31 = " = ";
  protected final String TEXT_32 = "();";
  protected final String TEXT_33 = NL + "            \tservice.";
  protected final String TEXT_34 = "(";
  protected final String TEXT_35 = ");" + NL + "                Map outputs = new java.util.HashMap();";
  protected final String TEXT_36 = "      " + NL + "                outputs.put (\"";
  protected final String TEXT_37 = "\", ";
  protected final String TEXT_38 = ");";
  protected final String TEXT_39 = NL + "                Collection ";
  protected final String TEXT_40 = "collection = new java.util.Vector<";
  protected final String TEXT_41 = ">();";
  protected final String TEXT_42 = NL + "                ";
  protected final String TEXT_43 = "collection.add(";
  protected final String TEXT_44 = ");" + NL + "                outputs.put (\"";
  protected final String TEXT_45 = "\", ";
  protected final String TEXT_46 = "collection);";
  protected final String TEXT_47 = "                " + NL + "                " + NL + "                return outputs;" + NL + "            }";
  protected final String TEXT_48 = NL + "            throw new ModelingServiceError(\"Service unknown \" + serviceName, null);" + NL + "       " + NL + "        }" + NL + "        catch (ModelingServiceError e)" + NL + "        {" + NL + "            throw e;" + NL + "        }" + NL + "        catch (Exception e)" + NL + "        {" + NL + "            e.printStackTrace();" + NL + "            throw new ModelingServiceError(\"Error during service execution\", e" + NL + "                    .toString());" + NL + "        }" + NL + "    }" + NL + "}";
  protected final String TEXT_49 = NL;

  public String generate(Object argument)
  {
    final StringBuffer stringBuffer = new StringBuffer();
     DescriptionModelLoader modelLoader = (DescriptionModelLoader) argument; 
    stringBuffer.append(TEXT_1);
     if (modelLoader.getOutputPackage()!="") {

    stringBuffer.append(TEXT_2);
    stringBuffer.append(modelLoader.getOutputPackage());
    stringBuffer.append(TEXT_3);
     }
    stringBuffer.append(TEXT_4);
     if (Toolkit.javadoc) { 
    stringBuffer.append(TEXT_5);
     } 
    stringBuffer.append(TEXT_6);
    stringBuffer.append(modelLoader.getTool().getName());
    stringBuffer.append(TEXT_7);
    stringBuffer.append(modelLoader.getTool().getName());
    stringBuffer.append(TEXT_8);
    stringBuffer.append(modelLoader.getTool().getName());
    stringBuffer.append(TEXT_9);
    stringBuffer.append(modelLoader.getTool().getName());
    stringBuffer.append(TEXT_10);
    stringBuffer.append(modelLoader.getTool().getName());
    stringBuffer.append(TEXT_11);
    for (ModelingServiceInterface msi : modelLoader.getModelingServiceInterfaces()) {
    stringBuffer.append(TEXT_12);
    stringBuffer.append(msi.getName());
    stringBuffer.append(TEXT_13);
      for (Iterator i = msi.getService().iterator(); i.hasNext();) {
	  ModelingService service = (ModelingService) i.next();
    stringBuffer.append(TEXT_14);
    stringBuffer.append(service.getName());
    stringBuffer.append(TEXT_15);
        int paramnumber = 0;
      int outparam = 0;

        for (Iterator it = service.getParameter().iterator(); it.hasNext();)
      {
        Parameter param = (Parameter) it.next();
        if (param.getDirection() == DirectionKind.IN_LITERAL || param.getDirection() == DirectionKind.INOUT_LITERAL)
        {
          if (TypeConversion.isPrimitive (param)) {
    stringBuffer.append(TEXT_16);
    stringBuffer.append(TypeConversion.generateType(param));
    stringBuffer.append(TEXT_17);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_18);
    stringBuffer.append(TypeConversion.generateType(param));
    stringBuffer.append(TEXT_19);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_20);
            } else {
    stringBuffer.append(TEXT_21);
    stringBuffer.append(TypeConversion.generateType(param));
    stringBuffer.append(TEXT_22);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_23);
    stringBuffer.append(TypeConversion.generateType(param));
    stringBuffer.append(TEXT_24);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_25);
            }
          paramnumber++;
          if (param.getDirection() != DirectionKind.IN_LITERAL)
            outparam++;
        }
        else
        {
           if (param.getDirection() == DirectionKind.RETURN_LITERAL) {
    stringBuffer.append(TEXT_26);
    stringBuffer.append(TypeConversion.generateType(param));
    stringBuffer.append(TEXT_27);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_28);
             } else {
    stringBuffer.append(TEXT_29);
    stringBuffer.append(TypeConversion.generateType(param));
    stringBuffer.append(TEXT_30);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_31);
    stringBuffer.append(TypeConversion.generateTypeCreation(param));
    stringBuffer.append(TEXT_32);
             }
        }
        } 
    String params = "";
    
    for (Iterator it = service.getParameter().iterator(); it.hasNext();) {
        Parameter param = (Parameter) it.next();
   	    if (param.getDirection() != DirectionKind.RETURN_LITERAL)
   	    {
   	       if (!params.equals(""))
   	           params += ", ";
   	       params += param.getName();
   	    }
   	} 	  	

    stringBuffer.append(TEXT_33);
    stringBuffer.append(service.getName());
    stringBuffer.append(TEXT_34);
    stringBuffer.append(params);
    stringBuffer.append(TEXT_35);
        int values = 0;
      outparam = 0;
      for (Iterator it = service.getParameter().iterator(); it.hasNext();) {
                   Parameter param = (Parameter) it.next();
        if (param.getDirection() != DirectionKind.IN_LITERAL) {
             if (TypeConversion.isPrimitive (param)) {

    stringBuffer.append(TEXT_36);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_37);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_38);
              } else {
    stringBuffer.append(TEXT_39);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_40);
    stringBuffer.append(TypeConversion.generateType(param));
    stringBuffer.append(TEXT_41);
    stringBuffer.append(TEXT_42);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_43);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_44);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_45);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_46);
              }
           outparam++;
        }
        values++;
      } 
    stringBuffer.append(TEXT_47);
      } 
    } 
    stringBuffer.append(TEXT_48);
    stringBuffer.append(TEXT_49);
    return stringBuffer.toString();
  }
}
