package org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet;

import java.util.*;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.TypeConversion;
import org.eclipse.mddi.modelbus.description.abstract_.*;
import org.eclipse.mddi.modelbus.toolkit.Toolkit;

public class StubTemplate
{
  protected static String nl;
  public static synchronized StubTemplate create(String lineSeparator)
  {
    nl = lineSeparator;
    StubTemplate result = new StubTemplate();
    nl = null;
    return result;
  }

  public final String NL = nl == null ? (System.getProperties().getProperty("line.separator")) : nl;
  protected final String TEXT_1 = "/*" + NL + "* Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus." + NL + "* All rights reserved." + NL + "*" + NL + "* This software is published under the terms of the ModelBus Software License" + NL + "* in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even" + NL + "* the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE." + NL + "* A copy of ModelBus Software License is provided with this distribution in" + NL + "* doc/LICENSE.txt file." + NL + "*/" + NL;
  protected final String TEXT_2 = NL + "package ";
  protected final String TEXT_3 = ";";
  protected final String TEXT_4 = NL + NL + "import java.util.Collection;" + NL + "import java.util.Properties;" + NL + "import java.util.Vector;" + NL + "" + NL + "import org.eclipse.mddi.modelbus.adapter.infrastructure.DeploymentException;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;" + NL + "import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.CopyRestoreTransportManager;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;" + NL + "import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;" + NL + "import org.eclipse.uml2.uml.NamedElement;" + NL + "import org.eclipse.uml2.uml.Package;" + NL + NL;
  protected final String TEXT_5 = NL + "/**" + NL + " * " + NL + " * " + NL + " * @author " + NL + " *  " + NL + " */";
  protected final String TEXT_6 = NL + "public class ";
  protected final String TEXT_7 = " implements ";
  protected final String TEXT_8 = ",";
  protected final String TEXT_9 = NL + "{" + NL + "    protected AdapterStub adapter;" + NL + "    " + NL + "\tpublic ";
  protected final String TEXT_10 = "(String registry_loc) throws DeploymentException" + NL + "\t{\t" + NL + "\t        Properties p = new Properties();" + NL + "\t\tp.put(AdapterStub.PROP_REGISTRY_LOCATION, registry_loc);" + NL + "\t\tadapter = new AdapterStubImpl(p);" + NL + "\t\tadapter.setTransportManager(new " + NL + "\t\t\tCopyRestoreTransportManager(adapter));" + NL + "\t}" + NL + "\t";
  protected final String TEXT_11 = NL + "\t// ";
  protected final String TEXT_12 = " interface";
  protected final String TEXT_13 = "   \t" + NL + "\tpublic ";
  protected final String TEXT_14 = " ";
  protected final String TEXT_15 = "(";
  protected final String TEXT_16 = ")" + NL + "   \t       throws ModelBusCommunicationException, ServiceUnknownException," + NL + "   \t              NoToolAvailableException, ModelTypeMismatchException" + NL + "\t{";
  protected final String TEXT_17 = NL + NL + "          java.util.Map inputs = new java.util.HashMap();" + NL + "      ";
  protected final String TEXT_18 = NL + "          inputs.put(\"";
  protected final String TEXT_19 = "\",";
  protected final String TEXT_20 = ");";
  protected final String TEXT_21 = NL + "          Collection ";
  protected final String TEXT_22 = "collection = new Vector();";
  protected final String TEXT_23 = NL + "          ";
  protected final String TEXT_24 = "collection.add (";
  protected final String TEXT_25 = ");" + NL + "          inputs.put(\"";
  protected final String TEXT_26 = "\",";
  protected final String TEXT_27 = "collection);";
  protected final String TEXT_28 = NL + "      " + NL + "          java.util.Map outputs =" + NL + "\t\t\tadapter.getGenericConsumer().consume(\"";
  protected final String TEXT_29 = ".";
  protected final String TEXT_30 = ".";
  protected final String TEXT_31 = "\", inputs);";
  protected final String TEXT_32 = NL + "          return (";
  protected final String TEXT_33 = ") outputs.get(\"";
  protected final String TEXT_34 = "\");";
  protected final String TEXT_35 = NL + "          return (";
  protected final String TEXT_36 = ")  ((Collection)outputs.get(\"";
  protected final String TEXT_37 = "\")).iterator().next();";
  protected final String TEXT_38 = NL + "     }       " + NL + "       ";
  protected final String TEXT_39 = NL + "}";
  protected final String TEXT_40 = NL;

  public String generate(Object argument)
  {
    final StringBuffer stringBuffer = new StringBuffer();
     DescriptionModelLoader modelLoader = (DescriptionModelLoader) argument; 
    stringBuffer.append(TEXT_1);
     if (modelLoader.getOutputPackage()!="") {

    stringBuffer.append(TEXT_2);
    stringBuffer.append(modelLoader.getOutputPackage());
    stringBuffer.append(TEXT_3);
     }
    stringBuffer.append(TEXT_4);
     if (Toolkit.javadoc) { 
    stringBuffer.append(TEXT_5);
     } 
    stringBuffer.append(TEXT_6);
    stringBuffer.append(modelLoader.getTool().getName());
    stringBuffer.append(TEXT_7);
     for (int i = 0; i < modelLoader.getModelingServiceInterfaces().length; i++) {
ModelingServiceInterface msi =  (ModelingServiceInterface) modelLoader.getModelingServiceInterfaces()[i];

    stringBuffer.append(msi.getName());
    
if (i < modelLoader.getModelingServiceInterfaces().length - 1)
    stringBuffer.append(TEXT_8);
    
} 
    stringBuffer.append(TEXT_9);
    stringBuffer.append(modelLoader.getTool().getName());
    stringBuffer.append(TEXT_10);
    for (ModelingServiceInterface msi : modelLoader.getModelingServiceInterfaces()) {
    stringBuffer.append(TEXT_11);
    stringBuffer.append(msi.getName());
    stringBuffer.append(TEXT_12);
     for (Iterator i = msi.getService().iterator(); i.hasNext();) {
	     ModelingService service = (ModelingService) i.next();
	     
	String ret = "void";
    String params = "";
    
    for (Iterator it = service.getParameter().iterator(); it.hasNext();) {
        Parameter param = (Parameter) it.next();
   	    if (param.getDirection() == DirectionKind.RETURN_LITERAL)
   	       ret = TypeConversion.generateType(param);
   	    else
   	    {
   	       if (!params.equals(""))
   	           params += ", ";
   	       params += TypeConversion.generateType(param) + " " + param.getName();
   	    }
   	} 	
 
    stringBuffer.append(TEXT_13);
    stringBuffer.append(ret);
    stringBuffer.append(TEXT_14);
    stringBuffer.append(service.getName());
    stringBuffer.append(TEXT_15);
    stringBuffer.append(params);
    stringBuffer.append(TEXT_16);
        int paramnumber = 0;
      int inparam = 0;

    stringBuffer.append(TEXT_17);
        for (Iterator it = service.getParameter().iterator(); it.hasNext();)
      {
        Parameter param = (Parameter) it.next();
        if (param.getDirection() != DirectionKind.OUT_LITERAL && param.getDirection() != DirectionKind.RETURN_LITERAL)
        {
         if (TypeConversion.isPrimitive (param)) {
    stringBuffer.append(TEXT_18);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_19);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_20);
           } else {
    stringBuffer.append(TEXT_21);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_22);
    stringBuffer.append(TEXT_23);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_24);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_25);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_26);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_27);
           }
          
          paramnumber++;
        }
        
      } 
    stringBuffer.append(TEXT_28);
    stringBuffer.append(modelLoader.getTool().getName());
    stringBuffer.append(TEXT_29);
    stringBuffer.append(msi.getName());
    stringBuffer.append(TEXT_30);
    stringBuffer.append(service.getName());
    stringBuffer.append(TEXT_31);
        for (Iterator it = service.getParameter().iterator(); it.hasNext();)
      {
        Parameter param = (Parameter) it.next();
        if (param.getDirection() == DirectionKind.OUT_LITERAL)
        {
        	System.err.println ("Warning out mode not supported by Java !");
        	
        }
        if (param.getDirection() == DirectionKind.RETURN_LITERAL)
        {
          if (TypeConversion.isPrimitive (param)) {
    stringBuffer.append(TEXT_32);
    stringBuffer.append(TypeConversion.generateType (param));
    stringBuffer.append(TEXT_33);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_34);
            } else {
    stringBuffer.append(TEXT_35);
    stringBuffer.append(TypeConversion.generateType (param));
    stringBuffer.append(TEXT_36);
    stringBuffer.append(param.getName());
    stringBuffer.append(TEXT_37);
            }            
        }
      }
    stringBuffer.append(TEXT_38);
        }
  }
    stringBuffer.append(TEXT_39);
    stringBuffer.append(TEXT_40);
    return stringBuffer.toString();
  }
}
