package org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet;

import java.util.*;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.description.abstract_.*;
import org.eclipse.mddi.modelbus.description.concrete.*;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.TypeConversion4XMLSchema;
import org.eclipse.mddi.modelbus.toolkit.Toolkit;

public class WSDLModelingInterfaceTemplate
{
  protected static String nl;
  public static synchronized WSDLModelingInterfaceTemplate create(String lineSeparator)
  {
    nl = lineSeparator;
    WSDLModelingInterfaceTemplate result = new WSDLModelingInterfaceTemplate();
    nl = null;
    return result;
  }

  public final String NL = nl == null ? (System.getProperties().getProperty("line.separator")) : nl;
  protected final String TEXT_1 = "<wsdl:definitions xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" xmlns:mbns=\"http://www.eclipse.org/mddi/modelbus/\" xmlns:http=\"http://schemas.xmlsoap.org/wsdl/http/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:mime=\"http://schemas.xmlsoap.org/wsdl/mime/\" xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" xmlns:soap12=\"http://schemas.xmlsoap.org/wsdl/soap12/\" targetNamespace=\"http://www.eclipse.org/mddi/modelbus/\">" + NL;
  protected final String TEXT_2 = NL + "<wsdl:types>" + NL + "<xsd:schema elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\" targetNamespace=\"http://www.eclipse.org/mddi/modelbus/\" xmlns:mbns=\"http://www.eclipse.org/mddi/modelbus/\">" + NL;
  protected final String TEXT_3 = NL + "<xsd:element name=\"Resource\">" + NL + "<xsd:complexType>" + NL + "<xsd:simpleContent>" + NL + "<xsd:extension base=\"xsd:string\">" + NL + "<xsd:attribute name=\"uri\" type=\"xsd:string\" use=\"optional\"/>" + NL + "</xsd:extension>" + NL + "</xsd:simpleContent>" + NL + "</xsd:complexType>" + NL + "</xsd:element>" + NL;
  protected final String TEXT_4 = NL + "<xsd:element name=\"Scope\">" + NL + "<xsd:complexType>" + NL + "<xsd:sequence>" + NL + "<xsd:element minOccurs=\"0\" maxOccurs=\"1\" ref=\"mbns:Resource\" /> " + NL + "</xsd:sequence>" + NL + "</xsd:complexType>" + NL + "</xsd:element>" + NL;
  protected final String TEXT_5 = NL + "<xsd:element name=\"Ref\">" + NL + "<xsd:complexType>" + NL + "<xsd:attribute name=\"uri\" type=\"xsd:string\" use=\"required\"/>" + NL + "<xsd:attribute name=\"fragment\" type=\"xsd:string\" use=\"required\"/>" + NL + "</xsd:complexType>" + NL + "</xsd:element>" + NL;
  protected final String TEXT_6 = NL + "<xsd:element name=\"model\">" + NL + "<xsd:complexType>" + NL + "<xsd:sequence>" + NL + "<xsd:element minOccurs=\"0\" maxOccurs=\"unbounded\" ref=\"mbns:Ref\" /> " + NL + "</xsd:sequence>" + NL + "<xsd:attribute name=\"encoding\" type=\"xsd:string\" use=\"required\"/>" + NL + "</xsd:complexType>" + NL + "</xsd:element>" + NL;
  protected final String TEXT_7 = NL + "<xsd:element name=\"stringset\">" + NL + "<xsd:complexType>" + NL + "<xsd:sequence>" + NL + "<xsd:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"stringElement\" type=\"xsd:string\" /> " + NL + "</xsd:sequence>" + NL + "</xsd:complexType>" + NL + "</xsd:element>" + NL;
  protected final String TEXT_8 = NL + "<xsd:element name=\"booleanset\">" + NL + "<xsd:complexType>" + NL + "<xsd:sequence>" + NL + "<xsd:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"booleanElement\" type=\"xsd:boolean\" /> " + NL + "</xsd:sequence>" + NL + "</xsd:complexType>" + NL + "</xsd:element>" + NL;
  protected final String TEXT_9 = NL + "<xsd:element name=\"integerset\">" + NL + "<xsd:complexType>" + NL + "<xsd:sequence>" + NL + "<xsd:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"integerElement\" type=\"xsd:integer\" /> " + NL + "</xsd:sequence>" + NL + "</xsd:complexType>" + NL + "</xsd:element>" + NL;
  protected final String TEXT_10 = NL + "<xsd:element name=\"doubleset\">" + NL + "<xsd:complexType>" + NL + "<xsd:sequence>" + NL + "<xsd:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"doubleElement\" type=\"xsd:double\" /> " + NL + "</xsd:sequence>" + NL + "</xsd:complexType>" + NL + "</xsd:element>" + NL;
  protected final String TEXT_11 = NL + "<xsd:element name=\"modelset\">" + NL + "<xsd:complexType>" + NL + "<xsd:sequence>" + NL + "<xsd:element minOccurs=\"0\" maxOccurs=\"unbounded\" ref=\"mbns:model\" /> " + NL + "</xsd:sequence>" + NL + "</xsd:complexType>" + NL + "</xsd:element>" + NL + "" + NL + "</xsd:schema>" + NL + "</wsdl:types>" + NL;
  protected final String TEXT_12 = NL;
  protected final String TEXT_13 = NL + "<wsdl:message name=\"";
  protected final String TEXT_14 = "_INPUT\">" + NL + "<wsdl:part name=\"SCOPE\" element=\"mbns:Scope\"/>";
  protected final String TEXT_15 = NL + "<wsdl:part name=\"";
  protected final String TEXT_16 = "\" ";
  protected final String TEXT_17 = "/>";
  protected final String TEXT_18 = NL + "</wsdl:message>" + NL;
  protected final String TEXT_19 = NL + "<wsdl:message name=\"";
  protected final String TEXT_20 = "_OUTPUT\">";
  protected final String TEXT_21 = NL + "<wsdl:part name=\"";
  protected final String TEXT_22 = "\" ";
  protected final String TEXT_23 = "/>";
  protected final String TEXT_24 = NL + NL + "</wsdl:message>";
  protected final String TEXT_25 = NL;
  protected final String TEXT_26 = NL + "<wsdl:portType name=\"";
  protected final String TEXT_27 = "\">";
  protected final String TEXT_28 = NL + "<wsdl:operation name=\"";
  protected final String TEXT_29 = "\">" + NL + "<wsdl:input message=\"mbns:";
  protected final String TEXT_30 = "_INPUT\"/>" + NL + "<wsdl:output message=\"mbns:";
  protected final String TEXT_31 = "_OUTPUT\"/>" + NL + "</wsdl:operation>";
  protected final String TEXT_32 = NL + "</wsdl:portType>  " + NL;
  protected final String TEXT_33 = NL + "<wsdl:binding name=\"";
  protected final String TEXT_34 = "ModelBusSOAP11Binding\" type=\"mbns:";
  protected final String TEXT_35 = "\">" + NL + "<soap:binding transport=\"http://schemas.xmlsoap.org/soap/http\" style=\"document\" />";
  protected final String TEXT_36 = NL + "<wsdl:operation name=\"";
  protected final String TEXT_37 = "\">" + NL + "<soap:operation soapAction=\"\" style=\"document\" /> " + NL + "<wsdl:input>" + NL + "<soap:body use=\"literal\" /> " + NL + "</wsdl:input>" + NL + "<wsdl:output>" + NL + "<soap:body use=\"literal\" /> " + NL + "</wsdl:output>" + NL + "</wsdl:operation>";
  protected final String TEXT_38 = NL + " " + NL + "</wsdl:binding>" + NL;
  protected final String TEXT_39 = NL + "<wsdl:service name=\"";
  protected final String TEXT_40 = "\">" + NL + "<wsdl:port name=\"";
  protected final String TEXT_41 = "ModelBusSOAP11port_http\" binding=\"mbns:";
  protected final String TEXT_42 = "ModelBusSOAP11Binding\">" + NL + "<soap:address location=\"\" /> " + NL + "</wsdl:port>" + NL + "</wsdl:service>" + NL + "" + NL + "</wsdl:definitions>" + NL;
  protected final String TEXT_43 = NL;

  public String generate(Object argument)
  {
    final StringBuffer stringBuffer = new StringBuffer();
     DescriptionModelLoader modelLoader = (DescriptionModelLoader) argument; 
     Tool tool = modelLoader.getTool(); 
     ModelingServiceInterface modelingServiceI = tool.getInterface(); 
    // --
    // Definition --
    stringBuffer.append(TEXT_1);
    // types 
    stringBuffer.append(TEXT_2);
    // Resource Type 
    stringBuffer.append(TEXT_3);
    // Scope Type 
    stringBuffer.append(TEXT_4);
    // Ref 
    stringBuffer.append(TEXT_5);
    // Model type 
    stringBuffer.append(TEXT_6);
    // Sets
    // StringSet
    stringBuffer.append(TEXT_7);
    // BooleanSet
    stringBuffer.append(TEXT_8);
    // IntegerSet
    stringBuffer.append(TEXT_9);
    // DoubleSet
    stringBuffer.append(TEXT_10);
    // ModelSet
    stringBuffer.append(TEXT_11);
    // messages 
    for (Iterator it = modelingServiceI.getService().iterator() ; it.hasNext() ; ) { 
ModelingService currentService = (ModelingService) it.next(); 
    // two messages (in and out) for each modelling service 
    stringBuffer.append(TEXT_12);
    //message input
    stringBuffer.append(TEXT_13);
    stringBuffer.append(currentService.getName());
    stringBuffer.append(TEXT_14);
    // one part for each (in, inout) parameter 
    for (Iterator itParam = currentService.getParameter().iterator() ; itParam.hasNext() ; ) {
Parameter currentParameter = (Parameter) itParam.next(); 
    if ((currentParameter.getDirection() == DirectionKind.IN_LITERAL) || (currentParameter.getDirection() == DirectionKind.INOUT_LITERAL)) { 
    stringBuffer.append(TEXT_15);
    stringBuffer.append(currentParameter.getName());
    stringBuffer.append(TEXT_16);
    stringBuffer.append(TypeConversion4XMLSchema.generateType(currentParameter));
    stringBuffer.append(TEXT_17);
    }
    }
    stringBuffer.append(TEXT_18);
    //message output
    stringBuffer.append(TEXT_19);
    stringBuffer.append(currentService.getName());
    stringBuffer.append(TEXT_20);
    for (Iterator itParam = currentService.getParameter().iterator() ; itParam.hasNext() ; ) {
Parameter currentParameter = (Parameter) itParam.next(); 
    if ((currentParameter.getDirection() == DirectionKind.OUT_LITERAL) || (currentParameter.getDirection() == DirectionKind.INOUT_LITERAL) || (currentParameter.getDirection() == DirectionKind.RETURN_LITERAL)) { 
    stringBuffer.append(TEXT_21);
    stringBuffer.append(currentParameter.getName());
    stringBuffer.append(TEXT_22);
    stringBuffer.append(TypeConversion4XMLSchema.generateType(currentParameter));
    stringBuffer.append(TEXT_23);
    }
    }
    stringBuffer.append(TEXT_24);
    }
    stringBuffer.append(TEXT_25);
    // portType 
    stringBuffer.append(TEXT_26);
    stringBuffer.append(modelingServiceI.getName());
    stringBuffer.append(TEXT_27);
    for (Iterator it = modelingServiceI.getService().iterator() ; it.hasNext() ; ) { 
ModelingService currentService = (ModelingService) it.next(); 
    // Operation 
    stringBuffer.append(TEXT_28);
    stringBuffer.append(currentService.getName());
    stringBuffer.append(TEXT_29);
    stringBuffer.append(currentService.getName());
    stringBuffer.append(TEXT_30);
    stringBuffer.append(currentService.getName());
    stringBuffer.append(TEXT_31);
    }
    stringBuffer.append(TEXT_32);
    //Binding 
    stringBuffer.append(TEXT_33);
    stringBuffer.append(tool.getName());
    stringBuffer.append(TEXT_34);
    stringBuffer.append(modelingServiceI.getName());
    stringBuffer.append(TEXT_35);
    for (Iterator it = modelingServiceI.getService().iterator() ; it.hasNext() ; ) { 
ModelingService currentService = (ModelingService) it.next(); 
    stringBuffer.append(TEXT_36);
    stringBuffer.append(currentService.getName());
    stringBuffer.append(TEXT_37);
    }
    stringBuffer.append(TEXT_38);
    //Service 
    stringBuffer.append(TEXT_39);
    stringBuffer.append(tool.getName());
    stringBuffer.append(TEXT_40);
    stringBuffer.append(tool.getName());
    stringBuffer.append(TEXT_41);
    stringBuffer.append(tool.getName());
    stringBuffer.append(TEXT_42);
    stringBuffer.append(TEXT_43);
    return stringBuffer.toString();
  }
}
