/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.test;

import java.io.IOException;

import junit.framework.TestCase;

import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.ParameterValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.PException;

/**
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 * 
 */
public class PValidationTest extends TestCase {

    /**
     * 
     * Test that ParameterException are thrown when needed
     * 
     */
    public static void testValidationParameter() {

        String xmlFileName;
        DescriptionModelLoader modelLoader;

        xmlFileName = "P_missingType.description";

        try {
            modelLoader = new DescriptionModelLoader(ValidationTest
                    .getDescriptionFilesPath()
                                                     + xmlFileName);
            ParameterValidation.validationParameter(modelLoader.getModelBusPackaging());
            assertEquals(true, false);
        } catch (IOException e) {
            assertEquals(true, false);
        } catch (PException e) {
            assertEquals(false, false);
        }

        xmlFileName = "P_emptyType.description";
        try {
            modelLoader = new DescriptionModelLoader(ValidationTest
                    .getDescriptionFilesPath()
                                                     + xmlFileName);
            ParameterValidation.validationParameter(modelLoader.getModelBusPackaging());
            assertEquals(true, false);
        } catch (IOException e) {
            assertEquals(true, false);
        } catch (PException e) {
            assertEquals(false, false);
        }

        //case never thrown because of xmi Error : 
    	//java.lang.IllegalArgumentException 
    	//(when direction is different from enumerator specification)
        /*xmlFileName = "P_DirectionKind.description";
        try {
            modelLoader = new DescriptionModelLoader(ValidationTest.getDescriptionFilesPath()
                                                     + xmlFileName);
            PValidation.validationParameter(modelLoader.getModelBusPackaging());
            assertEquals(true, false);
        } catch (IOException e) {
            e.printStackTrace();
            assertEquals(true, true);
        } catch (PException e) {
            assertEquals(false, false);
        }*/

        xmlFileName = "P_LowerSupThanUpper.description";
        try {
            modelLoader = new DescriptionModelLoader(ValidationTest.getDescriptionFilesPath()
                                                     + xmlFileName);
            ParameterValidation.validationParameter(modelLoader.getModelBusPackaging());
            assertEquals(true, false);
        } catch (IOException e) {
            assertEquals(true, false);
        } catch (PException e) {
            assertEquals(false, false);
        }

    }

}
