/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.test;

import java.io.IOException;

import junit.framework.TestCase;

import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.TypeValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TException;

/**
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 *  
 */
public class TValidationTest extends TestCase {

	/**
	 * Test method for
	 * 'org.eclipse.mddi.modelbus.toolkit.adapter.validator.TValidation.validationT(ModelBusPackaging)'
	 */
	public static void testValidationT() {

		String xmlFileName;
		DescriptionModelLoader modelLoader;
		xmlFileName = "Event_missingType.description";
		try {
			modelLoader = new DescriptionModelLoader(ValidationTest
					.getDescriptionFilesPath()
					+ xmlFileName);
			TypeValidation.validationT(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (TException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}

		xmlFileName = "Event_emptyType.description";
		try {
			modelLoader = new DescriptionModelLoader(ValidationTest
					.getDescriptionFilesPath()
					+ xmlFileName);
			TypeValidation.validationT(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (TException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}
		
		xmlFileName = "E_emptyType.description";
		try {
			modelLoader = new DescriptionModelLoader(ValidationTest
					.getDescriptionFilesPath()
					+ xmlFileName);
			TypeValidation.validationT(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (TException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}
		
		xmlFileName = "E_missingType.description";
		try {
			modelLoader = new DescriptionModelLoader(ValidationTest
					.getDescriptionFilesPath()
					+ xmlFileName);
			TypeValidation.validationT(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (TException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}
		
		xmlFileName = "P_emptyType.description";
		try {
			modelLoader = new DescriptionModelLoader(ValidationTest
					.getDescriptionFilesPath()
					+ xmlFileName);
			TypeValidation.validationT(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (TException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}
		
		xmlFileName = "P_missingType.description";
		try {
			modelLoader = new DescriptionModelLoader(ValidationTest
					.getDescriptionFilesPath()
					+ xmlFileName);
			TypeValidation.validationT(modelLoader.getModelBusPackaging());
			assertEquals(false, true);
		} catch (TException e) {
			assertEquals(false, false);
		} catch (IOException e1) {
			assertEquals(false, true);
			e1.printStackTrace();
		}

	}
}
