/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.EException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;

/**
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 */
public class ErrorValidation {

	/**
	 * the minimum value of the lower attribute
	 */
	public final static int MIN_INSTANCES_INFERIOR = 0;
	
	/**
	 * the minimum value of the upper attribute, 0 excluded, -1 for infinity
	 */
	public final static int MAX_INSTANCES_INFERIOR = -1;
	
	/** 
	 * This method validates the part of the description which specifies an
	 * Error.
	 * 
	 * @param mp
	 * @throws EException
	 */
	public static void validationE(ModelBusPackaging mp) throws EException{

		//we collect the contents list of the model
		EList mpListContents;
		mpListContents = mp.getContent();
		EList servicesList, errorsList;
		ModelingService service;
		ModelingServiceInterface msi = null;
		for (int j = 0; j < mpListContents.size(); j++) {
			Object content = mpListContents.get(j);
			if (content instanceof ModelingServiceInterface) {
				msi = (ModelingServiceInterface) content;

				//we collect the ModelingService of the
				// ModelingServiceInterface
				servicesList = msi.getService();

				//we loop on the services
				//and we treat every kind of user's errors
				for (int i = 0; i < servicesList.size(); i++) {
					service = (ModelingService) servicesList.get(i);
					errorsList = service.getServiceError();
					checkErrorsList(errorsList, mpListContents);
				}
			}
		}
	}

	/**
	 * 
	 * This method checks the attributes name , lower , upper of an
	 * serviceError.
	 * 
	 * @param errorsList 
	 * @param mpListContents 
	 * @throws EException 
	 */
	private static void checkErrorsList(EList errorsList, EList mpListContents)
			throws EException {
		Error error;
		for (int i = 0; i < errorsList.size(); i++) {
			error = (Error) errorsList.get(i);

			//if the Error has no name we raise the exception
			//if it has no type
			try {
			Validation.validateName(error.getName(), "Error");
			Validation.validateName(error.getType().getName(), "Error Type");
			} catch (NameFormatException e) {
				throw new EException(e.getMessage());
			}
			
			if (error.getUpper() == 0 && error.getLower() == 0) {
				throw new EException(
						"Error \""
								+ error.getName()
								+ "\" has its lower and upper attributes equal to 0, it must be different");
			} else if (error.getUpper() < error.getLower()
					&& error.getUpper() > 0) {
				throw new EException(
						"Error \""
								+ error.getName()
								+ "\" has its lower attribute superior as its upper attribute,the lower attribute must be inferior or equal to the upper attribute");
			} else if (error.getUpper() < MAX_INSTANCES_INFERIOR) {
				throw new EException("Error \""
						+ error.getName()
						+ "\" has its upper attribute inferior than "
						+ MAX_INSTANCES_INFERIOR +
						" the upper attribute must be superior or equal than "
						+ MAX_INSTANCES_INFERIOR);
			} else if (error.getLower() < MIN_INSTANCES_INFERIOR) {
				throw new EException("Error \""
						+ error.getName()
						+ "\" has its lower attribute inferior than "
						+ MIN_INSTANCES_INFERIOR +
						" the upper attribute must be superior or equal than "
						+ MIN_INSTANCES_INFERIOR);
			}
		}
	}
}
