/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import java.util.ArrayList;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MetaSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;

/**
 * 
 * Check that MetaclassSpecification are correctly formed
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 */
public class MetaSValidation {
	
	/**
	 * the minimum value of the lower attribute
	 */
	public final static int MIN_INSTANCES_INFERIOR = 0;
	
	/**
	 * the minimum value of the upper attribute, 0 excluded, -1 for infinity
	 */
	public final static int MAX_INSTANCES_INFERIOR = -1;

	/**
	 * 
	 * This method validates the part of the description which specifies an
	 * MetaclassSpecification.
	 * 
	 * @param mP
	 * @throws MetaSException
	 */
	public static void validateMetaS(ModelBusPackaging mP)
			throws MetaSException {
		EList mPcontents = mP.getContent();
		ArrayList modelTypeList = new ArrayList();
		int nextContent = 0;
		while (nextContent < mPcontents.size()) {
			Object mPcontent = mPcontents.get(nextContent);
			if (mPcontent instanceof ModelType) {
				ModelType mT = (ModelType) mPcontent;
				modelTypeList.add(mT);
			}
			nextContent++;
		}
		// for each ModelType instance
		for (int i = 0; i < modelTypeList.size(); i++) {
			ModelType mT = (ModelType) modelTypeList.get(i);
			if (!mT.getContent().isEmpty()) {
				EList mTcontents = mT.getContent();
				//for each MetaSpecification instance of each ModelType
				// instance
				for (int j = 0; j < mTcontents.size(); j++) {
					Object mTcontent = mTcontents.get(j);
					if (mTcontent instanceof MetaclassSpecification) {
						MetaclassSpecification metaS = (MetaclassSpecification) mTcontent;
						//if the metaS name is correct
						try {
							Validation.validateName(metaS.getName(),
									"MetaclassSpecification");
						} catch (NameFormatException e) {
							throw new MetaSException(e.getMessage());
						}
						if (metaS.getUpper() == 0 && metaS.getLower() == 0) {
							throw new MetaSException(
									"MetaclassSpecification \""
											+ metaS.getName()
											+ "\" has its lower and upper attributes equal to 0, it must be different");
						} else if (metaS.getUpper() < metaS.getLower()
								&& metaS.getUpper() > 0) {
							throw new MetaSException(
									"MetaclassSpecification \""
											+ metaS.getName()
											+ "\" has its lower attribute superior as its upper attribute,the lower attribute must be inferior or equal to the upper attribute");
						} else if (metaS.getUpper() < MAX_INSTANCES_INFERIOR) {
							throw new MetaSException("MetaclassSpecification \""
									+ metaS.getName()
									+ "\" has its upper attribute inferior than "
									+ MAX_INSTANCES_INFERIOR +
									" the upper attribute must be superior or equal than "
									+ MAX_INSTANCES_INFERIOR);
						} else if (metaS.getLower() < MIN_INSTANCES_INFERIOR) {
							throw new MetaSException("MetaclassSpecification \""
									+ metaS.getName()
									+ "\" has its lower attribute inferior than "
									+ MIN_INSTANCES_INFERIOR +
									" the upper attribute must be superior or equal than "
									+ MIN_INSTANCES_INFERIOR);
						}
					}
				}
			}
		}
	}

}
