/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.Event;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.abstract_.Type;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.EException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ETException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MPException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSIException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MetaSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.PException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ToolException;

/**
 * 
 * Check that ModelBusPackaging are correctly formed
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 */
public class ModelBusPackagingValidation {

	/**
	 * true if the description file contains a ModelingServiceInterface
	 */
	static boolean msiFound = false;

	/**
	 * The number of Tools that appears in the sons of the first
	 * ModelBusPackaging (must be 0)
	 */
	static int toolsFound = 0;

	/**
	 * 
	 * This method validates the part of the description which specifies a
	 * ModelBusPackaging.
	 * 
	 * @param mP
	 * @throws MPException
	 * @throws MSIException
	 * @throws TException
	 * @throws EException
	 * @throws ETException
	 * @throws NameFormatException
	 * @throws MetaSException
	 * @throws MSException
	 * @throws PException
	 * @throws ToolException
	 */
	public static synchronized void validateMP(ModelBusPackaging mP) throws MPException,
			MSIException, TException, EException, ETException,
			NameFormatException, MetaSException, MSException, PException,
			ToolException {
    
	    int someToolsFound = 0;
		EList mPContents = mP.getContent();
		 
		for (int i = 0; i < mPContents.size(); i++) {
			Object mPContent = mPContents.get(i);
			if (mPContent instanceof ModelBusPackaging) {
				Validation.globalValidationRec((ModelBusPackaging) mPContent);
			} else if (mPContent instanceof ModelingServiceInterface) {
				msiFound = true;
				ModelingServiceInterfaceValidation.validateMSI(mP);
			} else if (mPContent instanceof Type) {
				TypeValidation.validationT(mP);
			} else if (mPContent instanceof Tool) {
			    someToolsFound++;
				System.out.println("Some Tools found:"+someToolsFound);
			} else if (mPContent instanceof Event) {
				;
			} else {
				throw new MPException(
						"The ModebusPackaging \""
								+ mP.getName()
								+ "\" has a wrong content, it must contains only :"
								+ " at least one ModelingServiceinterface or ModelBusPackaging,"
								+ " Event and Type elements if needed");
			}
		}
		
		toolsFound=someToolsFound;
	}

	/**
	 * @return Returns the msiFound.
	 */
	public static boolean isMsiFound() {
		return msiFound;
	}

	/**
	 * @return Returns the msiFound.
	 */
	public static synchronized int getToolsFound() {
	    System.out.println("get Tools found:"+toolsFound);
		return toolsFound;
	}

}
