/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ToolException;

/**
 * 
 * Check that Tool are correctly formed
 * 
 * @author Fateh Bekhouche, Fatima Fadil, Nicolas Garandeau, Nils Henner,
 *         Saoussen Kraiem, Remy-Christophe Schermesser, Marc Schwitzguebel
 */
public class ToolValidation {

	/**
	 * 
	 * This method validates the part of the description which specifies a Tool.
	 * 
	 * @param mP
	 * @throws ToolException
	 */
	public static void validateTool(ModelBusPackaging mP) throws ToolException {
		EList mPContents = mP.getContent();
		for (int i = 0; i < mPContents.size(); i++) {
			Object mPContent = mPContents.get(i);
			if (mPContent instanceof Tool) {
				try {
					Validation.validateName(((Tool) mPContent).getName(),
							"Tool");
				} catch (NameFormatException e) {
					throw new ToolException(e.getMessage());
				}
			}
		}
	}
}
