/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.DeploymentException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.ProviderEndPoint;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class AdapterContainerImpl
implements AdapterContainer {
    private static AdapterContainerImpl instance = new AdapterContainerImpl();
    ProviderEndPoint msProviderEndPoint = new ProviderEndPoint();
    Collection adapters = this.msProviderEndPoint.getAdapters();

    public static AdapterContainer getInstance() {
        return instance;
    }

    private AdapterContainerImpl() {
        EndPointManagerImpl.getInstance().putEndPoint("modeling_services", this.msProviderEndPoint);
    }

    public void deployAdapter(AdapterStub adapter) throws DeploymentException {
        DeploymentException exception = new DeploymentException();
        try {
            if (adapter.getToolDescription() != null) {
                this.msProviderEndPoint.manageAdapter(adapter);
            }
        }
        catch (MalformedURLException e) {
            exception.addProblem("Bad tool URL in tool description", e);
            RootLogger.getLogger().log(Level.SEVERE, "Bad tool URL in tool description : " + e);
        }
        catch (Exception e) {
            exception.addProblem("Could not deploy Tool to Server", e);
            RootLogger.getLogger().log(Level.INFO, "Could not deploy Tool to Server : " + e);
        }
        try {
            if (adapter.getToolDescription() != null) {
                if (adapter.getToolStub().getProvider() == null && adapter.getToolStub().getProvider2() == null && adapter.getToolStub().getSessionProvider() == null) {
                    RootLogger.getLogger().log(Level.SEVERE, "No tool impl for " + adapter.getToolDescription().getName());
                    exception.addProblem("No tool impl", new NullPointerException());
                }
                RootLogger.getLogger().log(Level.INFO, "Registering Tool: " + adapter.getToolDescription().getName());
                RegistryManager.getInstance().registerTool(adapter);
            }
        }
        catch (RegistryNotAvailableException e) {
            exception.addProblem("Could not register tool", e);
            RootLogger.getLogger().log(Level.SEVERE, "Could not register tool : " + e);
        }
        try {
            NotifServiceManager.getInstance().subscribeNotificationConsumer(adapter);
        }
        catch (NotifServiceNotAvailableException e) {
            exception.addProblem("Could not subscribe NotificationConsumer", e);
            RootLogger.getLogger().log(Level.SEVERE, "Could not subscribe NotificationConsumer : " + e);
        }
        if (exception.hasProblems()) {
            throw exception;
        }
    }

    public void undeployAdapter(AdapterStub adapter) throws DeploymentException {
        DeploymentException exception = new DeploymentException();
        try {
            this.msProviderEndPoint.removeAdapter(adapter);
            this.adapters.remove(adapter);
        }
        catch (Exception e) {
            exception.addProblem("Could not unbind tool", e);
            RootLogger.getLogger().log(Level.SEVERE, "Could not deregister tool : " + e);
        }
        try {
            RegistryManager.getInstance().deregisterTool(adapter);
        }
        catch (RegistryNotAvailableException e) {
            exception.addProblem("Could not deregister tool", e);
            RootLogger.getLogger().log(Level.SEVERE, "Could not deregister tool", e);
        }
        try {
            NotifServiceManager.getInstance().unsubscribeNotificationConsumer(adapter);
        }
        catch (NotifServiceNotAvailableException e) {
            exception.addProblem("Could not unsubscribe NotificationConsumer", e);
            RootLogger.getLogger().log(Level.SEVERE, "Could not unsubscribe NotificationConsumer : " + e);
        }
        if (exception.hasProblems()) {
            throw exception;
        }
    }

    public boolean containsTool(Tool toolDesc) {
        for (AdapterStub adapter : this.adapters) {
            Tool testTool = adapter.getToolDescription();
            if (!DescriptionUtil.isToolEqual(testTool, toolDesc)) continue;
            return true;
        }
        return false;
    }

    public Collection getAdapters() {
        return this.adapters;
    }

    class AdapterContainerShutdown
    extends Thread {
        AdapterContainerShutdown() {
        }

        public void run() {
            Collection adapters = AdapterContainerImpl.getInstance().getAdapters();
            for (AdapterStub adapter : adapters) {
                try {
                    AdapterContainerImpl.getInstance().undeployAdapter(adapter);
                }
                catch (Exception exception) {}
            }
        }
    }
}

