/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;

public class GlobalResourceRegistry {
    public static final List GLOBAL_URI_PREFIX_SET = new Vector();
    private URIConverter uriConverter = new URIConverterImpl();
    private Map resourceMap = new Hashtable();

    static {
        GLOBAL_URI_PREFIX_SET.add("pathmap://ModelBus/global");
        GLOBAL_URI_PREFIX_SET.add("http://");
    }

    public Collection getResources() {
        return this.resourceMap.values();
    }

    public void registerResource(URI globalURI, Resource r) throws GlobalResourceException {
        if (!GlobalResourceRegistry.hasGlobalURIScheme(globalURI)) {
            throw new GlobalResourceException("Global URI must have scheme 'pathmap' or 'http'");
        }
        if (GlobalResourceRegistry.hasGlobalURIScheme(r.getURI()) && !globalURI.equals((Object)r.getURI())) {
            throw new GlobalResourceException("Resource already associated to " + r.getURI());
        }
        if (this.resourceMap.containsKey(globalURI)) {
            Resource boundResource = (Resource)this.resourceMap.get(globalURI);
            if (boundResource == r) {
                RootLogger.getLogger().log(Level.INFO, "Duplicated registration (ignored): " + globalURI.toString());
                return;
            }
            throw new GlobalResourceException("Conflict registration: " + globalURI + " is already bound to " + boundResource + ". Cannot rebind to " + r);
        }
        if (this.resourceMap.containsValue(r)) {
            throw new GlobalResourceException("Conflict registration: " + r + " is already registered with a different URI." + " Cannot rebind to " + globalURI);
        }
        this.resourceMap.put(globalURI, r);
        RootLogger.getLogger().log(Level.INFO, "register uri: " + globalURI);
        if (!globalURI.equals((Object)r.getURI())) {
            this.uriConverter.getURIMap().put(r.getURI(), globalURI);
            r.setURI(globalURI);
        }
    }

    public Resource getResource(URI uri) {
        Resource r = null;
        if (GlobalResourceRegistry.hasGlobalURIScheme(uri) && (r = (Resource)this.resourceMap.get(uri)) != null) {
            return r;
        }
        URI normalizedURI = this.uriConverter.normalize(uri);
        r = (Resource)this.resourceMap.get(normalizedURI);
        if (r == null && GlobalResourceRegistry.hasGlobalURIScheme(normalizedURI)) {
            RootLogger.getLogger().log(Level.INFO, "resolve uri: " + uri + " -> " + r);
        }
        return r;
    }

    public URIConverter getURIConverter() {
        return this.uriConverter;
    }

    public static boolean hasGlobalURIScheme(URI uri) {
        return ModelUtil.uriBeginsWith(uri, GLOBAL_URI_PREFIX_SET);
    }

    public static class GlobalResourceException
    extends Exception {
        private static final long serialVersionUID = -4580625527117814989L;

        public GlobalResourceException(String message) {
            super(message);
        }
    }
}

