/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.logging.Level;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.GlobalResourceRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.UUIDXMIResourceFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.MBXmiResourceFactory;
import org.eclipse.mddi.modelbus.description.impl.DescriptionPackageImpl;

public class ModelBusResourceSet
extends ResourceSetImpl {
    public static final Resource.Factory xmiResourceFactory = new XMIResourceFactoryImpl();
    static GlobalResourceRegistry globalResourceRegistry = new GlobalResourceRegistry();
    public static final URI MB_DEFAULT_RES_URI = URI.createURI((String)"default_resource.modelbus");

    static {
        MBXmiResourceFactory.init();
        UUIDXMIResourceFactory.init();
        DescriptionPackageImpl.init();
        try {
            Resource r = EcorePackage.eINSTANCE.eResource();
            ModelBusResourceSet.getGlobalResourceRegistry().registerResource(r.getURI(), r);
        }
        catch (Exception e) {
            RootLogger.getLogger().log(Level.SEVERE, "cannot bind Ecore model to GlobalRegistry", e);
        }
    }

    public static void init() {
    }

    public static GlobalResourceRegistry getGlobalResourceRegistry() {
        return globalResourceRegistry;
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        EPackage ePackage = this.getPackageRegistry().getEPackage(uri.toString());
        if (ePackage != null) {
            return ePackage.eResource();
        }
        Resource r = globalResourceRegistry.getResource(uri);
        return r;
    }

    public Resource createResource(URI uri) {
        Resource result = globalResourceRegistry.getResource(uri);
        if (result != null) {
            return result;
        }
        result = super.createResource(uri);
        if (result == null) {
            result = xmiResourceFactory.createResource(uri);
        }
        if (GlobalResourceRegistry.hasGlobalURIScheme(uri)) {
            try {
                globalResourceRegistry.registerResource(uri, result);
            }
            catch (GlobalResourceRegistry.GlobalResourceException e) {
                RootLogger.getLogger().log(Level.SEVERE, "createResource", e);
            }
        }
        return result;
    }
}

