/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.MBXmiResourceFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.ModelBaseURIConverter;

public class ModelBaseResourceSet
extends ResourceSetImpl {
    public static final String EXTENSION = "modelbase_xmi";
    protected boolean resolveOnDemand = true;

    static {
        MBXmiResourceFactory.init();
        Map m = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        m.put(EXTENSION, MBXmiResourceFactory.INSTANCE);
    }

    public ModelBaseResourceSet(File localEnvironment) throws IOException {
        ModelBaseURIConverter c = this.createURIConverter();
        this.setURIConverter((URIConverter)c);
        c.setLocalEnvironment(localEnvironment);
    }

    protected ModelBaseURIConverter createURIConverter() {
        return new ModelBaseURIConverter();
    }

    public Resource createResource(URI uri) {
        URI nuri = this.getModelBaseURIConverter().normalize(uri);
        Resource r = null;
        r = EXTENSION.equals(nuri.fileExtension()) || "mb_xmi".equals(nuri.fileExtension()) ? MBXmiResourceFactory.INSTANCE.createResource(nuri) : super.createResource(nuri);
        if (r == null) {
            r = MBXmiResourceFactory.INSTANCE.createResource(nuri);
        }
        this.getResources().add((Object)r);
        return r;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        Resource resource = null;
        try {
            boolean canLoad = !ModelBaseURIConverter.hasRepositoryScheme(uri) || this.getModelBaseURIConverter().getLocalEnvironment() != null;
            resource = this.getResource(uri.trimFragment(), loadOnDemand && this.resolveOnDemand && canLoad);
            if (resource != null) {
                return resource.getEObject(uri.fragment());
            }
        }
        catch (WrappedException e) {
            String exceptionString = e.exception() == null ? e.toString() : e.exception().toString();
            RootLogger.getLogger().log(Level.FINE, "Resource " + uri.trimFragment() + " not resolved. " + exceptionString);
        }
        catch (Exception e) {
            RootLogger.getLogger().log(Level.FINE, "Resource " + uri.trimFragment() + " not resolved. " + e.toString());
        }
        return null;
    }

    public ModelBaseURIConverter getModelBaseURIConverter() {
        return (ModelBaseURIConverter)this.getURIConverter();
    }

    public boolean isResolveOnDemand() {
        return this.resolveOnDemand;
    }

    public void setResolveOnDemand(boolean resolveOnDemand) {
        this.resolveOnDemand = resolveOnDemand;
    }
}

