/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;

public class ModelBaseURIConverter
extends URIConverterImpl {
    public static String REPOSITORY_SCHEME = "repository";
    protected String localEnvironmentPath = null;
    protected File localEnvironment = null;

    public static boolean hasRepositoryScheme(URI uri) {
        return REPOSITORY_SCHEME.equals(uri.scheme());
    }

    public URI normalize(URI uri) {
        if (ModelBaseURIConverter.hasRepositoryScheme(uri)) {
            return uri;
        }
        if (this.localEnvironmentPath != null && uri.isFile()) {
            try {
                String filePath = new File(uri.toFileString()).getCanonicalPath();
                if (filePath.startsWith(this.localEnvironmentPath)) {
                    String path = filePath.substring(this.localEnvironmentPath.length());
                    URI uri2 = ModelBaseURIConverter.createRepositoryURI(path);
                    return uri2;
                }
            }
            catch (IOException e) {
                RootLogger.getLogger().log(Level.SEVERE, "error resolving " + uri + " " + e);
            }
        }
        return super.normalize(uri);
    }

    public InputStream createInputStream(URI uri) throws IOException {
        File f = this.getFile(uri);
        if (f != null) {
            return new FileInputStream(f);
        }
        try {
            return super.createInputStream(uri);
        }
        catch (Exception e) {
            throw new IOException(String.valueOf(e.toString()) + " uri=" + uri);
        }
    }

    public OutputStream createOutputStream(URI uri) throws IOException {
        File f = this.getFile(uri);
        if (f != null) {
            return new FileOutputStream(f);
        }
        try {
            return super.createOutputStream(uri);
        }
        catch (Exception e) {
            throw new IOException(String.valueOf(e.toString()) + " uri=" + uri);
        }
    }

    protected File getFile(URI uri) {
        if (!ModelBaseURIConverter.hasRepositoryScheme(uri)) {
            uri = this.normalize(uri);
        }
        if (ModelBaseURIConverter.hasRepositoryScheme(uri) && this.localEnvironment != null) {
            return new File(this.localEnvironment, uri.path());
        }
        return null;
    }

    public File getLocalEnvironment() {
        return this.localEnvironment;
    }

    public void setLocalEnvironment(File localEnvironment) throws IOException {
        if (localEnvironment == null) {
            this.localEnvironment = null;
            this.localEnvironmentPath = null;
        } else {
            this.localEnvironment = localEnvironment.getCanonicalFile();
            this.localEnvironmentPath = localEnvironment.getCanonicalPath();
        }
    }

    public static URI createRepositoryURI(String filePath) {
        if ((filePath = filePath.replace('\\', '/')).startsWith("/")) {
            return URI.createURI((String)(String.valueOf(REPOSITORY_SCHEME) + ":" + filePath));
        }
        return URI.createURI((String)(String.valueOf(REPOSITORY_SCHEME) + ":/" + filePath));
    }
}

