/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.GlobalResourceRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;

public class Uml2ModelUtil {
    public static String PREFIX_UML_PROFILE = "pathmap://ModelBus/UML2Profile/";

    static {
        UMLPackage.eINSTANCE.getUMLFactory();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
    }

    public static void init(URI umlResourceURI) {
        Uml2ModelUtil.registerPathmaps(umlResourceURI);
    }

    static void registerPathmaps(URI umlResourceURI) {
        URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), umlResourceURI.appendSegment("libraries").appendSegment(""));
        URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), umlResourceURI.appendSegment("metamodels").appendSegment(""));
        URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML_PROFILES/"), umlResourceURI.appendSegment("profiles").appendSegment(""));
    }

    public static Profile getRegisteredProfile(String profileName) {
        URI uri = Uml2ModelUtil.createProfileGlobalURI(profileName);
        Resource r = ModelBusResourceSet.getGlobalResourceRegistry().getResource(uri);
        Profile prof = (Profile)ModelUtil.findElementByName((Collection)r.getContents(), profileName);
        return prof;
    }

    public static Profile registerProfile(URI uri) throws IOException {
        ModelBusResourceSet rs = new ModelBusResourceSet();
        Resource r = rs.createResource(uri);
        r.load(null);
        for (Object o : r.getContents()) {
            if (!(o instanceof Profile)) continue;
            Profile prof = (Profile)o;
            Uml2ModelUtil.registerProfile(prof);
            return prof;
        }
        return null;
    }

    public static void registerProfile(Profile prof) {
        URI uri = Uml2ModelUtil.createProfileGlobalURI(prof.getName());
        Resource r = prof.eResource();
        if (r == null) {
            r = Uml2ModelUtil.createContainerResource(prof);
        }
        try {
            ModelBusResourceSet.getGlobalResourceRegistry().registerResource(uri, r);
        }
        catch (GlobalResourceRegistry.GlobalResourceException e) {
            RootLogger.getLogger().log(Level.SEVERE, "registerProfile", e);
        }
        Uml2ModelUtil.registerEcorePackagesOfProfile(prof);
    }

    public static void registerEcorePackagesOfProfile(Profile prof) {
        EAnnotation anno2 = null;
        for (EAnnotation anno2 : prof.getEAnnotations()) {
            if (!"ePackages".equals(anno2.getSource())) continue;
            for (EPackage ep : anno2.getContents()) {
                EPackage.Registry.INSTANCE.put((Object)ep.getNsURI(), (Object)ep);
            }
            return;
        }
    }

    public static void setAliasURIToProfile(URI aliasURI, Profile prof) {
        ModelBusResourceSet.getGlobalResourceRegistry().getURIConverter().getURIMap().put(aliasURI, prof.eResource().getURI());
    }

    static Resource createContainerResource(Profile prof) {
        ModelBusResourceSet rs = new ModelBusResourceSet();
        Resource r = rs.createResource(Uml2ModelUtil.createProfileGlobalURI(prof.getName()));
        r.getContents().add((Object)prof);
        return r;
    }

    static URI createProfileGlobalURI(String profileName) {
        return URI.createURI((String)(String.valueOf(PREFIX_UML_PROFILE) + profileName + ".profile.uml"));
    }

    public static boolean hasLink(Model umlModel, Profile profile) {
        for (Profile prof1 : umlModel.getAllAppliedProfiles()) {
            if (!prof1.equals(profile)) continue;
            RootLogger.getLogger().log(Level.INFO, "OK: model is linked to " + profile);
            return true;
        }
        RootLogger.getLogger().log(Level.INFO, "Not ok: model is not linked to " + profile);
        return false;
    }
}

