/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.notification;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotificationEndPoint;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.SerializedNotification;
import org.eclipse.mddi.modelbus.adapter.user.notification.Notification;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationConsumer;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationPublisher;

public class NotifServiceClient
implements NotificationPublisher {
    String notifServiceLocation;

    public NotifServiceClient(String _location) {
        this.notifServiceLocation = _location;
    }

    public void subscribeConsumer(int port, NotificationConsumer con, String topics) throws NotifServiceNotAvailableException {
        NotificationEndPoint notifDelegate = NotifServiceManager.getInstance().getNotificationEndPoint();
        try {
            String consumerUrl = notifDelegate.bindConsumerToServer(port, con);
            String[] topicArray = NotifServiceClient.getTopicArray(topics);
            NotifServiceManager.getInstance().getProtocol().subscribe(this.notifServiceLocation, consumerUrl, topicArray);
        }
        catch (NotifServiceNotAvailableException ne) {
            throw ne;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String[] getTopicArray(String topics) {
        StringTokenizer tokenizer = new StringTokenizer(topics, ",");
        Vector<String> c = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            String topic = tokenizer.nextToken();
            c.add(topic);
        }
        String[] topicArray = new String[c.size()];
        topicArray = c.toArray(topicArray);
        return topicArray;
    }

    public void unsubscribeConsumer(NotificationConsumer con) throws NotifServiceNotAvailableException {
        NotificationEndPoint notifEndPoint = NotifServiceManager.getInstance().getNotificationEndPoint();
        notifEndPoint.unbindConsumerFromServer(con);
        NotifServiceManager.getInstance().getProtocol().unsubscribe();
    }

    public void publish(Notification notif) throws NotifServiceNotAvailableException {
        SerializedNotification serialized = new SerializedNotification(notif);
        NotifServiceManager.getInstance().getProtocol().publish(this.notifServiceLocation, serialized.topic, serialized.message);
    }

    public boolean isAvailable() {
        return true;
    }
}

