/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.registry;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.Xmi2EmfConversion;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.DefaultToolSelector;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ToolSelectionStrategy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ws.AlreadyRegistered;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ws.WebRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ws.WebRegistryServiceLocator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.QualifiedServiceName;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.MetaclassSpecification;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryClient {
    String registry_location;
    WebRegistry registry;
    ToolSelectionStrategy defaultSelector = new DefaultToolSelector();
    Map<String, Tool> url2tool = new HashMap<String, Tool>();
    List<ModelingServiceInterface> modelingServiceInterfaces = new Vector<ModelingServiceInterface>();

    public RegistryClient(String _registry_location) throws RegistryNotAvailableException {
        try {
            this.registry_location = _registry_location;
            WebRegistryServiceLocator loc = new WebRegistryServiceLocator();
            this.registry = loc.getWebRegistry(new URL(this.registry_location));
        }
        catch (Exception e) {
            throw new RegistryNotAvailableException("URL= [" + this.registry_location + "]", e);
        }
    }

    public String getRegistryLocation() {
        return this.registry_location;
    }

    public ModelingService findServiceDescription(String serviceName) throws RegistryNotAvailableException, ServiceUnknownException {
        ModelingService s = this._findServiceDescription(serviceName);
        if (s != null) {
            return s;
        }
        this.loadDescriptionsFromRegistryForAllInterfaces();
        s = this._findServiceDescription(serviceName);
        if (s == null) {
            throw new ServiceUnknownException(serviceName);
        }
        return s;
    }

    private ModelingService _findServiceDescription(String serviceName) throws RegistryNotAvailableException, ServiceUnknownException {
        QualifiedServiceName qname = QualifiedServiceName.getQualifiedServiceName(serviceName);
        if (qname.interfaceName != null) {
            for (ModelingServiceInterface inf : this.modelingServiceInterfaces) {
                ModelingService s;
                if (!inf.getName().equals(qname.interfaceName) || (s = this.findModelingService(inf, qname.serviceName)) == null) continue;
                return s;
            }
        } else {
            for (ModelingServiceInterface inf : this.modelingServiceInterfaces) {
                ModelingService s = this.findModelingService(inf, qname.serviceName);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    private ModelingService findModelingService(ModelingServiceInterface inf, String name) {
        for (ModelingService s : inf.getService()) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public Tool lookupToolByModelingService(String serviceName, ToolSelectionStrategy selector) throws RegistryNotAvailableException, ServiceUnknownException {
        if (selector == null) {
            selector = this.defaultSelector;
        }
        Tool t = null;
        t = selector.selectTool(serviceName, this.url2tool.values());
        if (t != null) {
            return t;
        }
        this.loadDescriptionsFromRegistryForAllInterfaces();
        t = selector.selectTool(serviceName, this.url2tool.values());
        if (t == null) {
            throw new ServiceUnknownException(serviceName);
        }
        return t;
    }

    public List<Tool> lookupToolsByModelingService(String serviceName) throws RegistryNotAvailableException, ServiceUnknownException {
        List<Tool> result = this._lookupToolsByModelingService(serviceName);
        if (!result.isEmpty()) {
            return result;
        }
        this.loadDescriptionsFromRegistryForAllInterfaces();
        return this._lookupToolsByModelingService(serviceName);
    }

    private List<Tool> _lookupToolsByModelingService(String serviceName) throws RegistryNotAvailableException, ServiceUnknownException {
        QualifiedServiceName qname = QualifiedServiceName.getQualifiedServiceName(serviceName);
        Vector<Tool> result = new Vector<Tool>();
        for (Tool t : this.url2tool.values()) {
            if (t.getInterface() == null) continue;
            for (ModelingService s : t.getInterface().getService()) {
                if (qname.interfaceName != null && qname.interfaceName.equals(t.getInterface().getName()) && s.getName().equals(qname.serviceName)) {
                    result.add(t);
                    continue;
                }
                if (qname.interfaceName != null || !s.getName().equals(qname.serviceName)) continue;
                result.add(t);
            }
        }
        return result;
    }

    public void loadDescriptionsFromRegistryForAllInterfaces() throws RegistryNotAvailableException {
        try {
            String[] results = this.registry.lookupAllModelingServiceInterfaces();
            Collection col = this.toEmf(results);
            this.modelingServiceInterfaces.clear();
            this.modelingServiceInterfaces.addAll(ModelUtil.findElementByType(col, "ModelingServiceInterface"));
            this.url2tool.clear();
            for (ModelingServiceInterface interf : this.modelingServiceInterfaces) {
                this.loadDescriptionsFromRegistryByInterface(interf.getName());
            }
        }
        catch (IOException e) {
            throw new RegistryNotAvailableException(e);
        }
    }

    public void loadDescriptionsFromRegistryByInterface(String modelingServiceInterface) throws IOException {
        String[] results = this.registry.lookupToolsByModelingServiceInterface(modelingServiceInterface);
        Collection col = this.toEmf(results);
        Collection _tools = ModelUtil.findElementByType(col, "Tool");
        for (Tool t : _tools) {
            String url = DescriptionUtil.getProperty(t, "URL");
            if (url == null) continue;
            this.url2tool.put(url, t);
        }
        Collection modelTypes = ModelUtil.findElementByType(col, "ModelType");
        Iterator it2 = modelTypes.iterator();
        while (it2.hasNext()) {
            RegistryClient.registerMetaModels((ModelType)it2.next());
        }
    }

    private Collection toEmf(String[] results) throws IOException {
        RootLogger.getLogger().log(Level.INFO, "Registry lookup result: ");
        int i = 0;
        while (i < results.length) {
            RootLogger.getLogger().log(Level.INFO, results[i]);
            ++i;
        }
        Vector<String> strings = new Vector<String>();
        int i2 = 0;
        while (i2 < results.length) {
            strings.add(results[i2]);
            ++i2;
        }
        Collection emfobjs = new Xmi2EmfConversion().convertFromStrings(strings, false);
        return emfobjs;
    }

    public String registerTool(Tool desc) throws RegistryNotAvailableException {
        String token = new String();
        try {
            Vector<Tool> emfobjs = new Vector<Tool>();
            emfobjs.add(desc);
            String s = Emf2XmiConversion.convertToString(emfobjs);
            token = this.registry.registerTool(s);
            return token;
        }
        catch (Exception e) {
            if (e instanceof AlreadyRegistered) {
                RootLogger.getLogger().log(Level.WARNING, "Registering: Modeling Service is already registred");
                return token;
            }
            RootLogger.getLogger().log(Level.SEVERE, "Registry not available");
            throw new RegistryNotAvailableException("URL= [" + this.registry_location + "] " + e);
        }
    }

    public void deregisterTool(String token) throws RegistryNotAvailableException {
        try {
            this.registry.deregisterTool(token);
        }
        catch (Exception e) {
            throw new RegistryNotAvailableException("URL= " + this.registry_location, e);
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public Collection getTools() {
        return this.url2tool.values();
    }

    private static void registerMetaModels(ModelType type) {
        ModelType mtype = type;
        for (MetaclassSpecification metaspec : mtype.getContent()) {
            EClass metaclass = metaspec.getMetaClass();
            if (metaclass == null) {
                RootLogger.getLogger().log(Level.WARNING, "Cannot find the metaclass for ModelType " + type.getName() + " MetaclassSpecification " + metaspec.getName());
                continue;
            }
            if (metaclass.getEPackage() == null) {
                RootLogger.getLogger().log(Level.WARNING, "The metaclass " + metaclass.getName() + " has no container package, at ModelType " + type.getName());
                continue;
            }
            EPackage metamodel = RegistryClient.getOuterMostPackage(metaclass.getEPackage());
            RegistryClient.registerMetaModel(metamodel);
        }
    }

    private static EPackage getOuterMostPackage(EPackage pack) {
        EPackage next_pack = pack.getESuperPackage();
        while (next_pack != null) {
            pack = next_pack;
            next_pack = pack.getESuperPackage();
        }
        return pack;
    }

    private static void registerMetaModel(EPackage metamodel) {
        EPackage registered;
        String uri = metamodel.getNsURI();
        if (uri == null || "".equals(uri)) {
            EPackage superp = metamodel.getESuperPackage();
            uri = superp == null ? "http://model/" + metamodel.getName() : String.valueOf(superp.getNsURI()) + "/" + metamodel.getName();
            metamodel.setNsURI(uri);
        }
        if ((registered = EPackage.Registry.INSTANCE.getEPackage(metamodel.getNsURI())) != null && registered != metamodel) {
            RootLogger.getLogger().log(Level.WARNING, "The EPackage with NS URI " + metamodel.getNsURI() + " is already loaded! \n" + "It will be kept unchanged, though ModelBus Registry can contain an updated version.");
            return;
        }
        RootLogger.getLogger().log(Level.INFO, "Registring NS URI = " + metamodel.getNsURI() + "\for EPackage" + metamodel);
        EPackage.Registry.INSTANCE.put((Object)metamodel.getNsURI(), (Object)metamodel);
        for (EPackage subp : metamodel.getESubpackages()) {
            RegistryClient.registerMetaModel(subp);
        }
    }
}

