/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.GlobalResourceRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DeserializedModel;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelElementReference;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.SerializedXmiDocument;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelSerializer
implements ModelSerializer {
    public static final String IN_CONTENT = "IN_CONTENT";
    public static final String INOUT_CONTENT = "INOUT_CONTENT";
    public static final String OUT_CONTENT = "OUT_CONTENT";
    protected boolean skipCrossReferences = false;
    protected Collection ignoredUriPrefixSet = new Vector(GlobalResourceRegistry.GLOBAL_URI_PREFIX_SET);
    public boolean canChangeURI = true;
    protected List<Resource> sentResources;
    protected List<Resource> receivedResources;
    protected ResourceSet inoutResourceSet;
    protected ResourceSet defaultReceivedResourceSet;

    public boolean isSkipCrossReferences() {
        return this.skipCrossReferences;
    }

    public void setSkipCrossReferences(boolean skipCrossReferences) {
        this.skipCrossReferences = skipCrossReferences;
    }

    public Collection getIgnoredUriPrefixSet() {
        return this.ignoredUriPrefixSet;
    }

    @Override
    public SerializedXmiDocument[] serialize(List<Parameter> params, Map<String, Object> values) {
        Collection<EObject> allModelElements = this.getScope(params, values);
        this.sentResources = ModelUtil.getResourcesFromObjects(allModelElements, this.skipCrossReferences, this.ignoredUriPrefixSet);
        return this.serializeResources();
    }

    protected SerializedXmiDocument[] serializeResources() {
        HashSet<String> uris = new HashSet<String>();
        Vector<SerializedXmiDocument> docVector = new Vector<SerializedXmiDocument>();
        for (Resource r : this.sentResources) {
            try {
                SerializedXmiDocument doc = new SerializedXmiDocument();
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                this.saveResource(r, bout);
                doc.setXmi(bout.toString());
                String uri = r.getURI().toString();
                int i = 0;
                while (this.canChangeURI && uris.contains(uri)) {
                    uri = String.valueOf(r.getURI().trimFileExtension().toString()) + i + "." + r.getURI().fileExtension();
                    r.setURI(URI.createURI((String)uri));
                    RootLogger.getLogger().log(Level.WARNING, "Redundant URI. Changed to " + uri);
                    ++i;
                }
                doc.setUri(uri);
                uris.add(uri);
                docVector.add(doc);
            }
            catch (Exception e) {
                RootLogger.getLogger().log(Level.SEVERE, "", e);
            }
        }
        return docVector.toArray(new SerializedXmiDocument[docVector.size()]);
    }

    protected Collection<EObject> getScope(List<Parameter> params, Map<String, Object> values) {
        List inoutContent;
        List inContent;
        HashSet<EObject> result = new HashSet<EObject>();
        List content = (List)values.get(OUT_CONTENT);
        if (content != null) {
            result.addAll(content);
        }
        if ((inContent = (List)values.get(IN_CONTENT)) != null) {
            result.addAll(inContent);
        }
        if ((inoutContent = (List)values.get(INOUT_CONTENT)) != null) {
            result.addAll(inoutContent);
        }
        for (Parameter p : params) {
            int j;
            Object[] modelArray;
            if (!(p.getType() instanceof ModelType)) continue;
            Object value = values.get(p.getName());
            if (value instanceof List) {
                result.addAll((Collection)value);
            }
            if (value instanceof EObject[]) {
                modelArray = (EObject[])value;
                j = 0;
                while (j < modelArray.length) {
                    result.add(modelArray[j]);
                    ++j;
                }
            }
            if (value instanceof EObject) {
                EObject model = (EObject)value;
                result.add(model);
                continue;
            }
            if (!(value instanceof Collection[])) continue;
            modelArray = (Collection[])value;
            j = 0;
            while (j < modelArray.length) {
                result.addAll((Collection<EObject>)modelArray[j]);
                ++j;
            }
        }
        return result;
    }

    protected Resource getResultResource(URI uri) {
        ResourceSet rs = this.getResourceSetFor(uri);
        return rs.createResource(uri);
    }

    protected ResourceSet getResourceSetFor(URI uri) {
        if (this.defaultReceivedResourceSet == null) {
            this.defaultReceivedResourceSet = this.sentResources != null && this.sentResources.size() > 0 ? this.sentResources.get(0).getResourceSet() : new ResourceSetImpl();
        }
        if (this.inoutResourceSet == null) {
            this.inoutResourceSet = new ResourceSetImpl();
        }
        if (this.sentResources != null && ModelUtil.findResourceWithURI(uri.toString(), this.sentResources) != null) {
            return this.inoutResourceSet;
        }
        if (ModelUtil.containsURI(this.defaultReceivedResourceSet, uri)) {
            return this.inoutResourceSet;
        }
        return this.defaultReceivedResourceSet;
    }

    protected void saveResource(Resource r, OutputStream out) throws IOException {
        r.save(out, null);
    }

    protected void loadResource(Resource r, InputStream in) throws IOException {
        r.load(in, null);
    }

    @Override
    public DeserializedModel[] deserialize(SerializedXmiDocument[] documents) {
        DeserializedModel[] result = new DeserializedModel[documents.length];
        this.receivedResources = new Vector<Resource>();
        int i = 0;
        while (i < documents.length) {
            result[i] = new DeserializedModel();
            result[i].setUri(documents[i].getUri());
            ByteArrayInputStream bin = new ByteArrayInputStream(documents[i].getXmi().getBytes());
            Resource r = this.getResultResource(URI.createURI((String)documents[i].getUri()));
            this.receivedResources.add(r);
            if (r != null) {
                try {
                    this.loadResource(r, bin);
                }
                catch (IOException e) {
                    RootLogger.getLogger().log(Level.SEVERE, "Error in deserializing " + documents[i].getUri() + " " + e);
                }
                result[i].setValue(r);
            } else {
                RootLogger.getLogger().log(Level.SEVERE, "No resource factory for " + documents[i].getUri());
            }
            ++i;
        }
        return result;
    }

    @Override
    public ModelElementReference[] getReferences(Parameter p, Object o) {
        Vector<ModelElementReference> v = new Vector<ModelElementReference>();
        if (o instanceof Collection) {
            if (p.getUpper() == 1) {
                for (EObject eo : (Collection)o) {
                    Resource r = eo.eResource();
                    ModelElementReference ref = new ModelElementReference();
                    ref.setUri(r.getURI().toString());
                    ref.setRef(this.getReference(eo));
                    v.add(ref);
                }
            } else {
                Collection col = (Collection)o;
                EObject[] models = (EObject[])col.iterator().next();
                int i = 0;
                while (i < models.length) {
                    Resource r = models[i].eResource();
                    ModelElementReference ref = new ModelElementReference();
                    ref.setUri(r.getURI().toString());
                    ref.setRef(this.getReference(models[i]));
                    v.add(ref);
                    ++i;
                }
            }
        }
        if (o instanceof EObject) {
            EObject eo;
            eo = (EObject)o;
            Resource r = eo.eResource();
            ModelElementReference ref = new ModelElementReference();
            ref.setUri(r.getURI().toString());
            ref.setRef(this.getReference(eo));
            v.add(ref);
        }
        return v.toArray(new ModelElementReference[v.size()]);
    }

    protected String getReference(EObject o) {
        Resource r = o.eResource();
        return r.getURIFragment(o);
    }

    @Override
    public Object dereference(Parameter p, ModelElementReference[] refs) {
        Vector<EObject> v = new Vector<EObject>();
        int i = 0;
        while (i < refs.length) {
            String uri = refs[i].getUri();
            String ref = refs[i].getRef();
            Resource r = ModelUtil.findResourceWithURI(uri, this.receivedResources);
            if (r != null) {
                EObject eo = null;
                eo = this.dereference(r, ref);
                if (eo != null) {
                    v.add(eo);
                } else {
                    RootLogger.getLogger().log(Level.SEVERE, "Fragment Not Found " + uri + ", " + ref);
                    for (EObject o : r.getContents()) {
                        if (v.contains(o)) continue;
                        RootLogger.getLogger().log(Level.INFO, "Parameter p " + p.getName() + ": Adding top element " + o);
                        v.add(o);
                    }
                }
            } else {
                RootLogger.getLogger().log(Level.SEVERE, "Resource Not Found " + uri);
            }
            ++i;
        }
        return v;
    }

    protected EObject dereference(Resource r, String fragment) {
        return r.getEObject(fragment);
    }

    public boolean canChangeURI() {
        return this.canChangeURI;
    }

    public void setCanChangeURI(boolean canChangeURI) {
        this.canChangeURI = canChangeURI;
    }

    public List<Resource> getSentResources() {
        return this.sentResources;
    }

    public List<Resource> getReceivedResources() {
        return this.receivedResources;
    }
}

