/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.net.URL;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.mb_xmi.IdModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.uml2.ProfiledModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DefaultModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.local.LocalInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.local.LocalSessionInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultSessionWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultSessionWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.TransportManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.WsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class DefaultTransportManager
implements TransportManager {
    SessionManager sessionManager = new SessionManager();
    AdapterStub adapter;
    ModelSerializerFactory defaultModelSerializerFactory;
    List modelSerializerFactorySet = new Vector();

    public DefaultTransportManager(AdapterStub a) {
        this.adapter = a;
        this.defaultModelSerializerFactory = new DefaultModelSerializerFactory();
        this.modelSerializerFactorySet.add(this.defaultModelSerializerFactory);
        this.modelSerializerFactorySet.add(new IdModelSerializerFactory());
        this.modelSerializerFactorySet.add(new ProfiledModelSerializerFactory());
    }

    public ProviderProxy createProviderProxy(URL url) {
        DefaultWsInvocationSender p = new DefaultWsInvocationSender();
        p.setToolUrl(url);
        p.getMarshaler().setModelSerializerFactory(this.defaultModelSerializerFactory);
        return p;
    }

    public ProviderProxy createProviderProxy(Tool t) throws ModelBusCommunicationException {
        DefaultWsInvocationSender p = null;
        if (AdapterContainerImpl.getInstance().containsTool(t)) {
            RootLogger.getLogger().log(Level.INFO, "Local Call");
            p = new LocalInvocationSender();
        } else {
            p = new DefaultWsInvocationSender();
        }
        p.setToolDescription(t);
        p.getMarshaler().setModelSerializerFactory(this.defaultModelSerializerFactory);
        return p;
    }

    public SessionProviderProxy createSessionProviderProxy(Tool t) throws ModelBusCommunicationException {
        DefaultSessionWsInvocationSender p = null;
        if (!DescriptionUtil.getIsSessionEnabled(t)) {
            return p;
        }
        p = AdapterContainerImpl.getInstance().containsTool(t) ? new LocalSessionInvocationSender() : new DefaultSessionWsInvocationSender();
        p.setSessionManager(this.sessionManager);
        p.setToolDescription(t);
        p.getMarshaler().setModelSerializerFactory(this.defaultModelSerializerFactory);
        return p;
    }

    public WsInvocationReceiver createWsInvocationReceiver() {
        DefaultWsInvocationReceiver r = DescriptionUtil.getIsSessionEnabled(this.adapter.getToolDescription()) ? new DefaultSessionWsInvocationReceiver(this.adapter) : new DefaultWsInvocationReceiver(this.adapter);
        return r;
    }

    public void setDefaultModelSerializerFactory(ModelSerializerFactory modelSerializerFactory) {
        if (modelSerializerFactory == null) {
            RootLogger.getLogger().log(Level.INFO, "Default model serializer factory cannot be set to null.");
            return;
        }
        if (!this.modelSerializerFactorySet.contains(modelSerializerFactory)) {
            this.modelSerializerFactorySet.add(modelSerializerFactory);
        }
        this.defaultModelSerializerFactory = modelSerializerFactory;
    }

    public List getModelSerializerFactoryList() {
        return this.modelSerializerFactorySet;
    }

    public ModelSerializerFactory findModelSerializerFactory(String name) {
        int i = 0;
        while (i < this.modelSerializerFactorySet.size()) {
            ModelSerializerFactory f = (ModelSerializerFactory)this.modelSerializerFactorySet.get(i);
            if (f.getName().equals(name)) {
                return f;
            }
            ++i;
        }
        RootLogger.getLogger().log(Level.INFO, "Model serializer factory not found: " + name + ", Returning " + this.defaultModelSerializerFactory);
        return this.defaultModelSerializerFactory;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }
}

