/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws;

import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPoint;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.EndPointManager;

public class EndPointManagerImpl
implements EndPointManager {
    private static EndPointManager endPointManager = new EndPointManagerImpl();
    Map endPointMap = new Hashtable();

    public static EndPointManager getInstance() {
        return endPointManager;
    }

    public EndPoint getEndPoint(String relativePath) {
        for (String incompleteRelativePath : this.endPointMap.keySet()) {
            if (relativePath.startsWith("/modelbus/" + incompleteRelativePath)) {
                return (EndPoint)this.endPointMap.get(incompleteRelativePath);
            }
            if (!relativePath.startsWith(incompleteRelativePath)) continue;
            return (EndPoint)this.endPointMap.get(incompleteRelativePath);
        }
        return null;
    }

    public void putEndPoint(String incompleteRelativePath, EndPoint endPoint) {
        this.endPointMap.put(incompleteRelativePath, endPoint);
        RootLogger.getLogger().log(Level.INFO, "add path:" + incompleteRelativePath);
    }

    public void execute(String urlPath, SOAPEnvelope req, SOAPEnvelope resp) {
        EndPoint ep = this.getEndPoint(urlPath);
        if (ep != null) {
            try {
                ep.execute(urlPath, req, resp);
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        } else {
            RootLogger.getLogger().log(Level.INFO, "No EndPoint for url : " + urlPath);
        }
    }

    public void removeEndPoint(String incompleteRelativePath) {
        this.endPointMap.remove(incompleteRelativePath);
        RootLogger.getLogger().log(Level.INFO, "Endpoint removed : path= " + incompleteRelativePath);
    }
}

