/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.user.consumer.impl;

import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.QualifiedServiceName;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.RepositoryClient;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.TransportManager;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericConsumerImpl
implements GenericConsumer {
    AdapterStub adapter;
    private Map connectionId2provider = new Hashtable();

    public GenericConsumerImpl(AdapterStub adapter) {
        this.adapter = adapter;
    }

    @Override
    public Map consume(URL toolUrl, String targetService, Map<String, Object> inputMap) throws ModelBusCommunicationException {
        if (inputMap == null) {
            RootLogger.getLogger().log(Level.SEVERE, "null inputs");
            throw new ModelTypeMismatchException("null inputs");
        }
        ProviderProxy sender = this.adapter.getTransportManager().createProviderProxy(toolUrl);
        RepositoryClient client = new RepositoryClient(this);
        sender.getMarshaler().setRepositoryClient(client);
        ModelingService ms = this.adapter.getRegistryClient().findServiceDescription(targetService);
        return sender.invoke(ms, inputMap);
    }

    @Override
    public Map consume(String targetService, Map<String, Object> inputMap) throws ModelBusCommunicationException {
        String[] sessions = this.getOpenSessions(targetService);
        if (sessions.length > 0) {
            this.consume(targetService, inputMap, sessions[0]);
        }
        List<Tool> toolDescriptions = this.adapter.findToolDescriptions(targetService);
        QualifiedServiceName qname = QualifiedServiceName.getQualifiedServiceName(targetService);
        if (qname.toolName != null) {
            for (Tool t : toolDescriptions) {
                if (!t.getName().equals(qname.toolName)) continue;
                return this.consume(targetService, inputMap, t);
            }
            throw new NoToolAvailableException("tool " + qname.toolName);
        }
        for (Tool t : toolDescriptions) {
            try {
                return this.consume(targetService, inputMap, t);
            }
            catch (ModelingServiceError e) {
                throw e;
            }
            catch (ModelBusCommunicationException e) {
                RootLogger.getLogger().log(Level.INFO, "tool not available " + t.getName() + " url= " + DescriptionUtil.getUrl(t));
                RootLogger.getLogger().log(Level.INFO, e.toString());
            }
        }
        throw new NoToolAvailableException("already tried " + toolDescriptions);
    }

    public Map consume(String targetService, Map<String, Object> inputMap, Tool t) throws ModelBusCommunicationException {
        if (DescriptionUtil.getIsSessionEnabled(t)) {
            String sessionId = this.newSession(t);
            return this.consume(targetService, inputMap, sessionId);
        }
        ProviderProxy sender = this.adapter.getTransportManager().createProviderProxy(t);
        RepositoryClient client = new RepositoryClient(this);
        sender.getMarshaler().setRepositoryClient(client);
        ModelingService ms = DescriptionUtil.getServiceDescription(targetService, t);
        return sender.invoke(ms, inputMap);
    }

    @Override
    public Object[] consume(String targetService, Object[] parameterValues) throws ModelBusCommunicationException {
        ModelingService ms = this.adapter.getRegistryClient().findServiceDescription(targetService);
        Parameter[] inputParams = DescriptionUtil.get_in_inout_Parameters(ms).toArray(new Parameter[0]);
        Parameter[] outputParams = DescriptionUtil.get_out_inout_Parameters(ms).toArray(new Parameter[0]);
        Map<String, Object> inputMap = DescriptionUtil.array2Map(inputParams, parameterValues);
        Map outputMap = this.consume(targetService, inputMap);
        Object[] outputArray = DescriptionUtil.map2Array(outputParams, outputMap);
        return outputArray;
    }

    @Override
    public Map consume(String targetService, Map<String, Object> inputMap, String sessionId) throws ModelBusCommunicationException {
        TransportManager tm = this.adapter.getTransportManager();
        SessionManager sm = tm.getSessionManager();
        SessionProviderProxy sender = sm.getProviderProxy(sessionId);
        RepositoryClient client = new RepositoryClient(this);
        sender.getMarshaler().setRepositoryClient(client);
        ModelingService ms = this.adapter.getRegistryClient().findServiceDescription(targetService);
        return sender.invoke(ms, inputMap);
    }

    @Override
    public Object[] consume(String targetService, Object[] parameterValues, String sessionId) throws ModelBusCommunicationException {
        ModelingService ms = this.adapter.getRegistryClient().findServiceDescription(targetService);
        Parameter[] inputParams = DescriptionUtil.get_in_inout_Parameters(ms).toArray(new Parameter[0]);
        Parameter[] outputParams = DescriptionUtil.get_out_inout_Parameters(ms).toArray(new Parameter[0]);
        Map<String, Object> inputMap = DescriptionUtil.array2Map(inputParams, parameterValues);
        Map outputMap = this.consume(targetService, inputMap, sessionId);
        Object[] outputArray = DescriptionUtil.map2Array(outputParams, outputMap);
        return outputArray;
    }

    @Override
    public String newSession(String targetService) throws ModelBusCommunicationException, ServiceUnknownException {
        List<Tool> toolDescriptions = this.adapter.findToolDescriptions(targetService);
        for (Tool t : toolDescriptions) {
            try {
                return this.newSession(t);
            }
            catch (Exception e) {
                RootLogger.getLogger().log(Level.INFO, "tool not available " + t.getName() + " url= " + DescriptionUtil.getUrl(t));
                RootLogger.getLogger().log(Level.INFO, e.toString());
            }
        }
        throw new NoToolAvailableException("already tried " + toolDescriptions);
    }

    @Override
    public String newSession(Tool t) throws ModelBusCommunicationException, ServiceUnknownException {
        SessionProviderProxy proxy = this.adapter.getTransportManager().createSessionProviderProxy(t);
        String sessionId = proxy.newSession();
        return sessionId;
    }

    @Override
    public void endSession(String sessionId) throws ModelBusCommunicationException {
        TransportManager tm = this.adapter.getTransportManager();
        SessionManager sm = tm.getSessionManager();
        SessionProviderProxy proxy = sm.getProviderProxy(sessionId);
        RootLogger.getLogger().log(Level.INFO, "Proxy:" + proxy);
        proxy.endSession(sessionId);
    }

    @Override
    public String[] getAllOpenSessions() {
        String[] sessions = this.adapter.getTransportManager().getSessionManager().getAllOpenSessions();
        return sessions;
    }

    @Override
    public String[] getOpenSessions(String targetService) {
        String[] sessions = this.adapter.getTransportManager().getSessionManager().getOpenSessions(targetService);
        return sessions;
    }

    @Override
    public String consumeAsync(String targetService, Object[] parameterValues) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException {
        ModelingService ms = this.adapter.getRegistryClient().findServiceDescription(targetService);
        Parameter[] inputParams = DescriptionUtil.get_in_inout_Parameters(ms).toArray(new Parameter[0]);
        Map<String, Object> inputMap = DescriptionUtil.array2Map(inputParams, parameterValues);
        return this.consumeAsync(targetService, inputMap);
    }

    @Override
    public String consumeAsync(String targetService, Map<String, Object> inputMap) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException {
        String[] sessions = this.getOpenSessions(targetService);
        if (sessions.length > 0) {
            this.consumeAsync(targetService, inputMap, sessions[0]);
        }
        List<Tool> toolDescriptions = this.adapter.findToolDescriptions(targetService);
        for (Tool t : toolDescriptions) {
            try {
                if (DescriptionUtil.getIsSessionEnabled(t)) {
                    String sessionId = this.newSession(t);
                    return this.consumeAsync(targetService, inputMap, sessionId);
                }
                ProviderProxy sender = this.adapter.getTransportManager().createProviderProxy(t);
                RepositoryClient client = new RepositoryClient(this);
                sender.getMarshaler().setRepositoryClient(client);
                ModelingService ms = DescriptionUtil.getServiceDescription(targetService, t);
                String connectionId = sender.invokeAsync(ms, inputMap);
                this.connectionId2provider.put(connectionId, sender);
                return connectionId;
            }
            catch (ModelingServiceError e) {
                throw e;
            }
            catch (Exception e) {
                RootLogger.getLogger().log(Level.INFO, "tool not available " + t.getName() + " url= " + DescriptionUtil.getUrl(t));
                RootLogger.getLogger().log(Level.INFO, e.toString());
            }
        }
        throw new NoToolAvailableException("already tried " + toolDescriptions);
    }

    @Override
    public boolean isResultReady(String resultHolderID) {
        ProviderProxy sender = (ProviderProxy)this.connectionId2provider.get(resultHolderID);
        if (sender == null) {
            return false;
        }
        try {
            return sender.isResultReady(resultHolderID);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Object[] getResult(String connectionID) {
        ProviderProxy sender = (ProviderProxy)this.connectionId2provider.get(connectionID);
        try {
            Object[] result = sender.getResult(connectionID);
            this.connectionId2provider.remove(connectionID);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String consumeAsync(String targetService, Object[] parameterValues, String sessionId) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException {
        ModelingService ms = this.adapter.getRegistryClient().findServiceDescription(targetService);
        Parameter[] inputParams = DescriptionUtil.get_in_inout_Parameters(ms).toArray(new Parameter[0]);
        Map<String, Object> inputMap = DescriptionUtil.array2Map(inputParams, parameterValues);
        return this.consumeAsync(targetService, inputMap, sessionId);
    }

    @Override
    public String consumeAsync(String targetService, Map<String, Object> inputMap, String sessionId) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException {
        TransportManager tm = this.adapter.getTransportManager();
        SessionManager sm = tm.getSessionManager();
        SessionProviderProxy sender = sm.getProviderProxy(sessionId);
        RepositoryClient client = new RepositoryClient(this);
        sender.getMarshaler().setRepositoryClient(client);
        ModelingService ms = DescriptionUtil.getServiceDescription(targetService, sender.getToolDescription());
        String connectionId = sender.invokeAsync(ms, inputMap, sessionId);
        this.connectionId2provider.put(connectionId, sender);
        return connectionId;
    }
}

